<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'mainController';

//$route['signin']= 'portal/signin';

$route['ref'] = 'MainController/authenticateError';
$route['ref/(:any)'] = 'MainController/signin/$1';

$route['loginAuthentication'] = 'auth/MyAuth/signin_process';
$route['signOutUser'] = 'auth/MyAuth/signOutUser';


//backend
$route['backend'] = 'backend/dashboard';
$route['getDashboardBarChartData'] = 'pages/dashboard/BarChartData';
$route['getDonutChartData'] = 'pages/dashboard/TotalInfo';

//unit
$route['backend/unit'] = 'backend/unitController';
$route['dataHandling/getUnitData'] = 'backend/unitController/getUnitData';
$route['dataHandling/getUnitJsonData'] = 'backend/unitController/getUnitJsonData';
$route['newUnitEntryProcess'] = 'backend/unitController/newUnitEntryProcess';
$route['unitEditProcess'] = 'backend/unitController/UnitEditProcess';

//category
$route['backend/category'] = 'backend/categoryController';
$route['dataHandling/getCategoryJsonData'] = 'backend/categoryController/getCategoryJsonData';
$route['dataHandling/getCategoryData'] = 'backend/categoryController/getCategoryData';
$route['newCategoryEntryProcess'] = 'backend/categoryController/newCategoryEntryProcess';
$route['categoryEditProcess'] = 'backend/categoryController/CategoryEditProcess';
$route['deleteCategory'] = 'backend/categoryController/deleteCategory';

//sub-category
$route['backend/subCategory'] = 'backend/subCategoryController';
$route['dataHandling/getSubCategoryData'] = 'backend/subCategoryController/getSubCategoryData';
$route['dataHandling/getSubCategoryJsonData'] = 'backend/subCategoryController/getSubCategoryJsonData';
$route['newSubCategoryEntryProcess'] = 'backend/subCategoryController/newSubCategoryEntryProcess';
$route['subCategoryEditProcess'] = 'backend/subCategoryController/subCategoryEditProcess';
$route['deleteSubCategory'] = 'backend/subCategoryController/deleteSubCategory';

//brand 
$route['backend/brand'] = 'backend/brandController';
$route['dataHandling/getBrandData'] = 'backend/brandController/getBrandData';
$route['dataHandling/getBrandJsonData'] = 'backend/brandController/getBrandJsonData';
$route['dataHandling/addBrandLogo'] = 'backend/brandController/addBrandLogo';
$route['newBrandEntryProcess'] = 'backend/brandController/newBrandEntryProcess';
$route['brandEditProcess'] = 'backend/brandController/brandEditProcess';
$route['deleteBrand'] = 'backend/brandController/deleteBrand';

//product
$route['backend/product'] = 'backend/productController';
$route['newProductEntryProcess'] = 'backend/productController/newProductEntryProcess';
$route['dataHandling/getProductData'] = 'backend/productController/getProductData';
$route['dataHandling/addProductPicture'] = 'backend/productController/addProductPicture';
$route['productEditProcess'] = 'backend/productController/productEditProcess';
$route['deleteProduct'] = 'backend/productController/deleteProduct';

//notice
$route['backend/notice'] = 'backend/noticeController';
$route['newNoticeEntryProcess'] = 'backend/noticeController/newNoticeEntryProcess';
$route['dataHandling/getNoticeData'] = 'backend/noticeController/getNoticeData';
$route['noticeEditProcess'] = 'backend/noticeController/noticeEditProcess';

//feature products
$route['backend/feature_product'] = 'backend/FrontViewProductController';
$route['dataHandling/allProductJson'] = 'frontend/ProductController/all_product_json';
$route['dataHandling/allFeatureProductJson'] = 'frontend/ProductController/allFeatureProductJson';
$route['featureProductAdd'] = 'backend/FrontViewProductController/featureProductAdd';

//top sale products
$route['backend/top_sale_product'] = 'backend/FrontViewProductController/top_sale_product';
$route['dataHandling/allTopSaleProductJson'] = 'frontend/ProductController/allTopSaleProductJson';
$route['topSaleProductAdd'] = 'backend/FrontViewProductController/topSaleProductAdd';

//portfolio
$route['backend/portfolio'] = 'backend/PortfolioController';
$route['newPortfolioEntryProcess'] = 'backend/PortfolioController/newPortfolioEntryProcess';
$route['dataHandling/getPortfolioData'] = 'backend/PortfolioController/getPortfolioData';
$route['dataHandling/addPortfolioPicture'] = 'backend/PortfolioController/addPortfolioPicture';
$route['portfolioEditProcess'] = 'backend/PortfolioController/portfolioEditProcess';

//product inquiry 
$route['backend/product-inquiry'] = 'backend/ProductInquiryController';
$route['dataHandling/getProductInquiryData'] = 'backend/ProductInquiryController/getProductInquiryData';
$route['updateProductInquiryStatus'] = 'backend/ProductInquiryController/updateProductInquiryStatus';

//message
$route['backend/message'] = 'backend/ContactController';
$route['dataHandling/getContactData'] = 'backend/ContactController/getContactData';
$route['updateMessageStatus'] = 'backend/ContactController/updateMessageStatus';

//about
$route['backend/team'] = 'backend/AboutController';
$route['newTeamEntryProcess'] = 'backend/AboutController/newTeamEntryProcess';
$route['teamEditProcess'] = 'backend/AboutController/teamEditProcess';
$route['dataHandling/getTeamData'] = 'backend/AboutController/getTeamData';
$route['dataHandling/addTeamPicture'] = 'backend/AboutController/addTeamPicture';

//gallery
$route['backend/gallery'] = 'backend/AboutController/gallery';
$route['dataHandling/addGalleryPicture'] = 'backend/AboutController/addGalleryPicture';
$route['dataHandling/getGalleryData'] = 'backend/AboutController/getGalleryData';
$route['deleteGallery'] = 'backend/AboutController/deleteGallery';


//frontend
$route['category/(:any)/(:any)'] = 'frontend/ProductController/getCategoryProduct/$1/$2';
$route['brand/(:any)'] = 'frontend/ProductController/getBrandProduct/$1';
$route['product/(:any)/(:any)'] = 'frontend/ProductController/single_product/$1/$2';
$route['product'] = 'frontend/ProductController/all_product';
$route['portfolio'] = 'frontend/PortfolioController';
$route['portfolio/(:any)'] = 'frontend/PortfolioController/portfolio/$1';
$route['contact'] = 'frontend/contactController';
$route['send_message'] = 'frontend/contactController/send_message';
$route['getLastMessage'] = 'frontend/contactController/getLastMessage';
$route['send_quotation_inquiry'] = 'frontend/contactController/sendProductQuotationInquiry';
$route['about'] = 'MainController/about';
$route['gallery'] = 'MainController/gallery';

$route['404_override'] = 'Error404';
$route['translate_uri_dashes'] = FALSE;
