<?php
defined('BASEPATH') or exit('No direct script access allowed');

class MainController extends CI_Controller
{

	public function __construct()
	{

		parent::__construct();
		$this->load->model('auth/MyAuthentication', 'Authentication');
		$this->load->model('frontend/ProductModel', 'productModel');
		$this->load->model('pages/NoticeModel', 'noticeModel');
		$this->load->model('frontend/MainModel', 'frontendModel');
	}
	public function index()
	{
		$data['title'] = "Medisave Corporation";
		$data['content'] = 'pages/home';
		$data['brand_info'] = $this->frontendModel->getBrand();
		$data['notice'] = $this->noticeModel->getNotice();
		$data['product'] = $this->productModel->getFeatureProduct();
		$data['top_product'] = $this->productModel->topSaleProduct();
		$this->load->view('layout/main-layout', $data);
	}



	public function signin($hash)
	{

		if ($company_name = $this->Authentication->checkValidity($hash)) {

			$data['title'] = "Welcome To The Test Kit Portal";
			$data['content'] = 'pages/other/signin';
			$data['hash_id'] = $hash;
			$data['company_name'] = $company_name;
			$this->load->view('layout/login-layout', $data);
		} else {
			$this->authenticateError();
		}
	}


	public function logout()
	{
		$this->session->sess_destroy();
		redirect('/');
	}

	public function authenticateError()
	{
		//i didn't found any method so i just created it.
		return "Unable to Authenticate";
	}

	public function about()
	{
		$data['title'] = "Medisave Corporation";
		$data['content'] = 'pages/about';
		$data['team'] = $this->frontendModel->getTeam();
		$this->load->view('layout/main-layout', $data);
	}
	public function gallery()
	{
		$data['title'] = "Medisave Corporation";
		$data['content'] = 'pages/gallery';
		$data['gallery'] = $this->frontendModel->getGallery();
		$this->load->view('layout/main-layout', $data);
	}
}
