<?php
defined('BASEPATH') or exit('No direct script access allowed');

class AboutController extends CI_Controller
{


	public function __construct()
	{

		parent::__construct();

		if ($this->session->userdata('admin_logged_in') !== TRUE) {
			redirect('/');
		}

		$this->load->model('dataHandling/crud', 'crud');
		$this->load->model('pages/AboutModel', 'model');
		$this->load->model('TableModel/about/FetchTeamData', 'TableModel');
		$this->load->model('TableModel/about/FetchGalleryData', 'GalleryTableModel');
	}

	public function index()
	{
		$this->layouts->add_includes('assets/backend/js/pages/team.js');
		$data['title'] = "Team";
		$data['content'] = 'pages/main/team';
		$this->load->view('layout/backend-access', $data);
	}
	public function gallery()
	{
		$this->layouts->add_includes('assets/backend/js/pages/gallery.js');
		$data['title'] = "Gallery";
		$data['content'] = 'pages/main/gallery';
		$this->load->view('layout/backend-access', $data);
	}

	public function newTeamEntryProcess()
	{
		if ($this->input->is_ajax_request()) {
			$this->form_validation->set_rules('name', ' Name', 'required|trim');
			$this->form_validation->set_rules('designation', 'designation', 'required|trim');
			$this->form_validation->set_rules('serial', 'Serial', 'required|trim');

			if ($this->form_validation->run()) {

				$name = $this->input->post('name', TRUE);
				$designation = $this->input->post('designation', TRUE);
				$serial = $this->input->post('serial', TRUE);
				$dataSet = array(
					'name' => $name,
					'designation' => $designation,
					'serial' => $serial,
				);

				$table = "team";

				if ($this->crud->insertReturnData($dataSet, $table)) {
					$data['response'] = 'Team Added successfully';
				} else {
					$data['response'] = 'Error Occured';
				}
				echo json_encode($data);
			} else {
				$data['response'] = 'Validation Error';
				echo json_encode($data);
			}
		}
	}
	public function getTeamData()
	{
		if ($this->input->is_ajax_request()) {
			$list = $this->TableModel->get_datatables();
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {
				$no++;
				$row = array();
				$row[] = $no;
				$row[] = $data_n->name;
				$row[] = $data_n->designation;
				$row[] = $data_n->serial;
				$row[] = $data_n->status;
				$row[] = $data_n->publish_status;
				$row[] = sha1($data_n->team_id);
				$row[] = $data_n->picture;
				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->TableModel->count_all(),
				"recordsFiltered" => $this->TableModel->count_filtered(),
				"data" => $data,
			);
			//output to json format
			echo json_encode($output);
		}
	}
	public function getGalleryData()
	{
		if ($this->input->is_ajax_request()) {
			$list = $this->GalleryTableModel->get_datatables();
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {
				$no++;
				$row = array();
				$row[] = $no;
				$row[] = $data_n->picture;
				$row[] = sha1($data_n->gallery_id);
				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->GalleryTableModel->count_all(),
				"recordsFiltered" => $this->GalleryTableModel->count_filtered(),
				"data" => $data,
			);
			//output to json format
			echo json_encode($output);
		}
	}

	public function addTeamPicture()
	{
		if ($this->input->is_ajax_request()) {
			$hash_id = $this->input->post('team_id', TRUE);
			$result = $this->crud->getIDProcessing($hash_id, 'team_id', 'team');
			$team_id = $result->team_id;

			$image_exist = $this->model->exist_image($team_id);
			if (!empty($image_exist->picture)) {
				unlink('assets/img/team/' . $image_exist->picture);
			}
			$image_data = $this->input->post('image');
			list($type, $image_data) = explode(';', $image_data);
			list(, $image_data)      = explode(',', $image_data);
			$image_data = base64_decode($image_data);
			$imageName = time() . '.png';
			file_put_contents('assets/img/team/' . $imageName, $image_data);

			$dataSet = array(
				'picture' => $imageName,
				'publish_status' => "Published",
			);
			$table = "team";

			if ($this->crud->updateData($team_id, $dataSet, 'team_id', $table)) {
				$data['response'] = 'Picture Added successfully';
			} else {
				$data['response'] = 'Error Occured';
			}
			echo json_encode($data);
		}
	}

	public function addGalleryPicture()
	{
		if ($this->input->is_ajax_request()) {
						$image_data = $this->input->post('image');
			list($type, $image_data) = explode(';', $image_data);
			list(, $image_data)      = explode(',', $image_data);
			$image_data = base64_decode($image_data);
			$imageName = time() . '.png';
			file_put_contents('assets/img/gallery/' . $imageName, $image_data);

			$dataSet = array(
				'picture' => $imageName,
			);
			$table = "gallery";

			if ($this->crud->insertReturnData($dataSet, $table)) {
				$data['response'] = 'Picture Added successfully';
			} else {
				$data['response'] = 'Error Occured';
			}
			echo json_encode($data);
		}
	}

	public function teamEditProcess()
	{
		if ($this->input->is_ajax_request()) {
			$this->form_validation->set_rules('name', '', 'required|trim');
			$this->form_validation->set_rules('designation', '', 'required|trim');
			$this->form_validation->set_rules('serial', '', 'required|trim');
			$this->form_validation->set_rules('status', 'Status', 'required|trim');

			if ($this->form_validation->run()) {

				$hash_id = $this->input->post('team_id', TRUE);
				$result = $this->crud->getIDProcessing($hash_id, 'team_id', 'team');
				$team_id = $result->team_id;

				$name = $this->input->post('name', TRUE);
				$designation = $this->input->post('designation', TRUE);
				$serial = $this->input->post('serial', TRUE);
				$status = $this->input->post('status', TRUE);
				$dataSet = array(
					'name' => $name,
					'designation' => $designation,
					'serial' => $serial,
					'status' => $status,
				);
				$table = "team";

				if ($this->crud->updateData($team_id, $dataSet, 'team_id', $table)) {
					$data['response'] = 'Team update successfully';
				} else {
					$data['response'] = 'Error Occured';
				}
				echo json_encode($data);
			} else {
				$data['response'] = 'Validation Error';
				echo json_encode($data);
			}
		}
	}

	public function deleteGallery()
	{
		if ($this->input->is_ajax_request()) {
			$hash_id = $this->input->post('gallery_id', TRUE);
			$result = $this->crud->getIDProcessing($hash_id, 'gallery_id', 'gallery');
			$gallery_id = $result->gallery_id;
			$gallery_picture = $this->input->post('gallery_picture', TRUE);
			$table = 'gallery';

			if(!empty($gallery_picture)){
				unlink('assets/img/gallery/'.$gallery_picture);
			}

			if ($this->crud->deleteData($gallery_id, 'gallery_id', $table)) {
				$data['response'] = 'deleted_successfully';
				echo json_encode($data);
			} else {
				$data['response'] = 'Error occurred';
				echo json_encode($data);
			}
		}
		else {
			echo json_encode("unable to process non ajax request");
		}
	}
}
