<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class CategoryController extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('admin_logged_in')!==TRUE){
			redirect('/');
		}

		$this->load->model('dataHandling/crud','crud');
		$this->load->model('pages/CategoryModel','model');
		$this->load->model('TableModel/category/FetchCategoryData','TableModel');

	}
	public function index(){
		$this->layouts->add_includes('assets/backend/js/pages/category.js');
		$data['title']="Category";
		$data['content']='pages/main/category';
		$this->load->view('layout/backend-access',$data);
	}

	public function getCategoryData(){
		if ($this->input->is_ajax_request()){
			$list = $this->TableModel->get_datatables();
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {


				$no++;
				$row = array();
				$row[] = $no;
				$row[] = $data_n->category_name;
				$row[] = $data_n->serial;
				$row[] = $data_n->status;
				$row[] = sha1($data_n->category_id);


				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->TableModel->count_all(),
				"recordsFiltered" => $this->TableModel->count_filtered(),
				"data" => $data,
			);
			//output to json format
			echo json_encode($output);
		}
	}

	public function newCategoryEntryProcess(){
		if ($this->input->is_ajax_request())
		{
			$this->form_validation->set_rules('category_name','Category Name','required|trim');
			$this->form_validation->set_rules('serial','Serial','required|trim');

			if($this->form_validation->run()){

				$category_name=$this->input->post('category_name',TRUE);
				$serial=$this->input->post('serial',TRUE);
				$url = strtolower(trim(str_replace(" ", "-", $category_name)));
				$filtered_url = preg_replace('/[^A-Za-z0-9\-]/', '', $url);
				$filter_result = $this->model->exist_url($filtered_url);

				if($filter_result){
					$dataSet=array(
						'category_name'=>$category_name,
						'url'=>$filtered_url,
						'serial'=>$serial,
					);
					$table="category";

					if($this->crud->insertReturnData($dataSet,$table)){
						$data['response']='Category Added successfully';
						$data['type']='success';
					}
					else{
						$data['response']='Error Occured';
						$data['type']='error';
					}
				}
				else{
					$data['response']='Category already exist';
					$data['type']='warning';
				}
			}
			else{
				$data['response']='Validation Error';
				$data['type']='error';
			}
			echo json_encode($data);
		}
	}

	public function getCategoryJsonData(){
		$this->model->getCategoryInfo();
	}

	public function CategoryEditProcess(){
		if ($this->input->is_ajax_request())
		{
			$this->form_validation->set_rules('category_name','Category Name','required|trim');
			$this->form_validation->set_rules('serial','Serial','required|trim');
			$this->form_validation->set_rules('status','Status','required|trim');

			if($this->form_validation->run()){

				$category_id_sha1=$this->input->post('category_id',TRUE);
				$result=$this->crud->getIDProcessing($category_id_sha1,'category_id','category');
				$category_id= $result->category_id;

				$category_name=$this->input->post('category_name',TRUE);
				$status=$this->input->post('status',TRUE);
				$serial=$this->input->post('serial',TRUE);
				$url = strtolower(trim(str_replace(" ", "-", $category_name)));
				$filtered_url = preg_replace('/[^A-Za-z0-9\-]/', '', $url);
				$filter_result = $this->model->exist_url($filtered_url, $category_id);
				if($filter_result){
					$dataSet=array(
						'category_name'=>$category_name,
						'url'=>$filtered_url,
						'serial'=>$serial,
						'status'=>$status,
					);
					$table="category";

					if($this->crud->updateData($category_id,$dataSet,'category_id',$table)){
						$data['response']='Category update successfully';
						$data['type']='success';
					}
					else{
						$data['response']='Error Occured';
						$data['type']='error';
					}
				}
				else{
					$data['response']='Category already exist';
					$data['type']='warning';
				}
			}
			else{
				$data['response']='Validation Error';
				$data['type']='error';
			}
			echo json_encode($data);
		}
	}

	public function deleteCategory()
	{
		if ($this->input->is_ajax_request()) {
			$category_id_sha1=$this->input->post('category_id',TRUE);
			$result=$this->crud->getIDProcessing($category_id_sha1,'category_id','category');
			$category_id= $result->category_id;
			$table = 'category';

			$this->db->select('*');
			$this->db->where('category_id',$category_id);
			$query=$this->db->get('product');
			if($query->num_rows()>0){
				$data['response'] = 'Sorry! Reference in Product & Sub category';
				$data['type'] = 'error';
			}
			else{
				$this->db->select('*');
				$this->db->where('category_id',$category_id);
				$query=$this->db->get('sub_category');
				if($query->num_rows()>0){
					$data['response'] = 'Sorry! Sub category has reference';
					$data['type'] = 'error';
				}
				else{
					if ($this->crud->deleteData($category_id, 'category_id', $table)) {
						$data['response'] = 'Deleted Successfully';
						$data['type'] = 'success';
					} else {
						$data['response'] = 'Error occurred';
						$data['type'] = 'error';
					}
				}
			}
			echo json_encode($data);
		}
	}

}
