<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('admin_logged_in')!==TRUE){

			redirect('/');

		}

		$this->load->model('pages/DashboardModel','DashboardModel');

	}





	public function index(){
		$this->layouts->add_includes('assets/js/dashboard/dashboard.js');
		$data['title']="Welcome To Dashboard";
		$data['content']='pages/main/dashboard';
		$this->load->view('layout/dashboard-layout',$data);
	}

	public function BarChartData(){
		if ($this->input->is_ajax_request())
        {
            $year=date('Y');
            $company_id=$this->session->userdata('company_id',TRUE);
			$result=$this->DashboardModel->push_in_array($year,$company_id);
			echo json_encode($result);
        }
        else{
            redirect('/');
        }
	}

	public function TotalInfo(){
		if ($this->input->is_ajax_request())
        {
        	$company_id=$this->session->userdata('company_id',TRUE);
			$result=$this->DashboardModel->get_total_result($company_id);
			echo json_encode($result);
        }
        else{
            redirect('/');
        }
		
	}


}
