<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FrontViewProductController extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('admin_logged_in')!==TRUE){
			redirect('/');
		}

		$this->load->model('dataHandling/crud','crud');
		$this->load->model('pages/ProductModel','model');

	}
	public function index(){
		$this->layouts->add_includes('assets/backend/js/pages/feature_products.js');
		$data['title']="Feature Products";
		$data['content']='pages/main/feature_products';
		$this->load->view('layout/backend-access',$data);
	}

	public function top_sale_product(){
		$this->layouts->add_includes('assets/backend/js/pages/top_sale_product.js');
		$data['title']="Top Sale Products";
		$data['content']='pages/main/top_sale_product';
		$this->load->view('layout/backend-access',$data);
	}

	public function featureProductAdd(){
		if ($this->input->is_ajax_request()) {
			$product_id=$this->input->post('product_id');
			foreach ($product_id as $id){
				$product_id_sha1=$id;
				$result=$this->crud->getIDProcessing($product_id_sha1,'product_id','product');
				$product_id= $result->product_id;
				$new_pro_id[]=$result->product_id;
				$allData=$this->model->singleProduct($product_id);
				$presentation_status=$allData->presentation_status;

				if($presentation_status=='0'){
					$status='1';
				}
				else if($presentation_status=='1'){
					$status='1';
				}
				else if($presentation_status=='2'){
					$status='1,2';
				}
				else if($presentation_status=='1,2'){
					$status='1,2';
				}

				$dataSet=array(
					'presentation_status'=>$status,
				);
				$table="product";
				$this->crud->updateData($product_id,$dataSet,'product_id',$table);
			}

			$allDataNew=$this->model->getUnselectID($new_pro_id);
			foreach ($allDataNew as $oneData){
				$product_id= $oneData['product_id'];
				$presentation_status=$oneData['presentation_status'];

				if($presentation_status=='0'){
					$status='0';
				}
				else if($presentation_status=='1'){
					$status='0';
				}
				else if($presentation_status=='2'){
					$status='2';
				}
				else if($presentation_status=='1,2'){
					$status='2';
				}

				$dataSet=array(
					'presentation_status'=>$status,
				);
				$table="product";
				$this->crud->updateData($product_id,$dataSet,'product_id',$table);
			}

			$data['response']='Feature Product Added!';
			echo json_encode($data);
		}
	}


	public function topSaleProductAdd(){
		if ($this->input->is_ajax_request()) {
			$product_id=$this->input->post('product_id');
			foreach ($product_id as $id){
				$product_id_sha1=$id;
				$result=$this->crud->getIDProcessing($product_id_sha1,'product_id','product');
				$product_id= $result->product_id;
				$new_pro_id[]=$result->product_id;
				$allData=$this->model->singleProduct($product_id);
				$presentation_status=$allData->presentation_status;

				if($presentation_status=='0'){
					$status='2';
				}
				else if($presentation_status=='1'){
					$status='1,2';
				}
				else if($presentation_status=='2'){
					$status='2';
				}
				else if($presentation_status=='1,2'){
					$status='1,2';
				}

				$dataSet=array(
					'presentation_status'=>$status,
				);
				$table="product";
				$this->crud->updateData($product_id,$dataSet,'product_id',$table);
			}

			$allDataNew=$this->model->getUnselectID($new_pro_id);
			foreach ($allDataNew as $oneData){
				$product_id= $oneData['product_id'];
				$presentation_status=$oneData['presentation_status'];

				if($presentation_status=='0'){
					$status='0';
				}
				else if($presentation_status=='1'){
					$status='1';
				}
				else if($presentation_status=='2'){
					$status='0';
				}
				else if($presentation_status=='1,2'){
					$status='1';
				}

				$dataSet=array(
					'presentation_status'=>$status,
				);
				$table="product";
				$this->crud->updateData($product_id,$dataSet,'product_id',$table);
			}

			$data['response']='Top Sale Product Added!';
			echo json_encode($data);
		}
	}

}
