<?php

class NoticeController extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('admin_logged_in') !== TRUE) {
			redirect('/');
		}

		$this->load->model('dataHandling/crud', 'crud');
		$this->load->model('pages/NoticeModel', 'model');
		$this->load->model('TableModel/notice/FetchNoticeData', 'TableModel');
	}

	public function index()
	{
		$this->layouts->add_includes('assets/backend/js/pages/notice.js');
		$data['title'] = "Notice";
		$data['content'] = 'pages/main/notice';
		$this->load->view('layout/backend-access', $data);
	}

	public function getNoticeData()
	{
		if ($this->input->is_ajax_request()) {
			$list = $this->TableModel->get_datatables();
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {
				if($data_n->status==1){
					$status='Active';
				}
				else{
					$status='De-Active';
				}
				$no++;
				$row = array();
				$row[] = $no;
				$row[] = date('dS F, Y h:i A',strtotime($data_n->execute_dt));
				$row[] = $data_n->notice;
				$row[] = $status;
				$row[] = $data_n->status;
				$row[] = sha1($data_n->notice_id );

				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->TableModel->count_all(),
				"recordsFiltered" => $this->TableModel->count_filtered(),
				"data" => $data,
			);
			//output to json format
			echo json_encode($output);
		}
	}

	public function newNoticeEntryProcess()
	{
		if ($this->input->is_ajax_request()) {
			$this->form_validation->set_rules('notice', 'notice', 'required|trim');

			if ($this->form_validation->run()) {

				$notice = $this->input->post('notice', TRUE);
				$dataSet = array(
					'notice' => $notice,
					'execute_by' => $this->session->userdata('auth_id', TRUE),
				);

				$table = "notice";

				if ($this->crud->insertReturnData($dataSet, $table)) {
					$data['response'] = 'Notice save successfully';
				} else {
					$data['response'] = 'Error Occured';
				}
				echo json_encode($data);
			} else {
				$data['response'] = 'Validation Error';
				echo json_encode($data);
			}
		}
	}

	public function noticeEditProcess()
	{
		if ($this->input->is_ajax_request()) {
			$this->form_validation->set_rules('notice', 'notice', 'required|trim');
			$this->form_validation->set_rules('status', 'Status', 'required|trim');

			if ($this->form_validation->run()) {

				$hash_id = $this->input->post('notice_id', TRUE);
				$result = $this->crud->getIDProcessing($hash_id, 'notice_id', 'notice');
				$notice_id = $result->notice_id;

				$notice = $this->input->post('notice', TRUE);
				$status = $this->input->post('status', TRUE);
				$dataSet = array(
					'notice' => $notice,
					'execute_by' => $this->session->userdata('auth_id', TRUE),
					'status' => $status,
				);
				$table = "notice";
				if ($this->crud->updateData($notice_id, $dataSet, 'notice_id', $table)) {
					$data['response'] = 'Notice update successfully';
				} else {
					$data['response'] = 'Error Occured';
				}
				echo json_encode($data);
			} else {
				$data['response'] = 'Validation Error';
				echo json_encode($data);
			}
		}
	}


	public function getNoticeJsonData()
	{
		if ($this->input->is_ajax_request()) {
			$this->model->getNoticeJsonData();
		}
	}
}
