<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PortfolioController extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('admin_logged_in')!==TRUE){
			redirect('/');
		}

		$this->load->model('dataHandling/crud','crud');
		$this->load->model('pages/PortfolioModel','model');
		$this->load->model('TableModel/portfolio/FetchPortfolioData','TableModel');

	}

	public function index(){
		$this->layouts->add_includes('assets/backend/js/pages/portfolio.js');
		$data['title']="Portfolio";
		$data['content']='pages/main/portfolio';
		$this->load->view('layout/backend-access',$data);
	}

	public function newPortfolioEntryProcess(){
		if ($this->input->is_ajax_request())
		{
			$this->form_validation->set_rules('date','Date','required|trim');
			$this->form_validation->set_rules('portfolio_title','Portfolio title','required|trim');
			$this->form_validation->set_rules('company_name','company_name','required|trim');
			$this->form_validation->set_rules('company_address','company_address','required|trim');
			$this->form_validation->set_rules('content','content','required|trim');
			$check=$this->input->post('check',TRUE);
			if($check=='on'){
				$this->form_validation->set_rules('contact_person','contact_person','required|trim');
				$this->form_validation->set_rules('contact_person_post','contact_person_post','required|trim');
				$this->form_validation->set_rules('testimonial','Testimonial','required|trim');
			}

			if($this->form_validation->run()){
				$date=$this->input->post('date',TRUE);
				$new_date=date("Y-m-d",strtotime(str_replace('/','-',$date)));
				$portfolio_title=$this->input->post('portfolio_title',TRUE);
				$company_name=$this->input->post('company_name',TRUE);
				$company_address=$this->input->post('company_address',TRUE);
				$content=$this->input->post('content',TRUE);
				$url = strtolower(trim(str_replace(" ", "-", $portfolio_title)));
				$filtered_url = preg_replace('/[^A-Za-z0-9\-]/', '', $url);
				$filter_result = $this->model->exist_url($filtered_url);
				if($filter_result){
					if($check=='on'){
						$contact_person=$this->input->post('contact_person',TRUE);
						$contact_person_post=$this->input->post('contact_person_post',TRUE);
						$testimonial=$this->input->post('testimonial',TRUE);
						$testimonial_status='TRUE';
						$dataSet=array(
							'portfolio_title'=>$portfolio_title,
							'company_name'=>$company_name,
							'company_address'=>$company_address,
							'date'=>$new_date,
							'content'=>$content,
							'contact_person'=>$contact_person,
							'contact_person_post'=>$contact_person_post,
							'testimonial'=>$testimonial,
							'tesimonial_status'=>$testimonial_status,
							'url'=>$filtered_url,
						);
					}
					else{
						$testimonial_status='FALSE';
						$dataSet=array(
							'portfolio_title'=>$portfolio_title,
							'company_name'=>$company_name,
							'company_address'=>$company_address,
							'date'=>$new_date,
							'content'=>$content,
							'contact_person'=>'',
							'contact_person_post'=>'',
							'testimonial'=>'',
							'tesimonial_status'=>$testimonial_status,
							'url'=>$filtered_url,
						);
					}

					$table="portfolio";

					if($this->crud->insertReturnData($dataSet,$table)){
						$data['response']='Portfolio Added successfully';
						$data['type']='success';
					}
					else{
						$data['response']='Error Occured';
						$data['type']='error';
					}
				}
				else{
					$data['response']='Portfolio Already exist';
					$data['type']='warning';
				}
			}
			else{
				$data['response']='Validation Error';
				$data['type']='error';
			}
			echo json_encode($data);
		}
	}


	public function getPortfolioData(){
		if ($this->input->is_ajax_request()){
			$list = $this->TableModel->get_datatables();
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {
				$no++;
				$row = array();
				$row[] = $no;
				$row[] = date('d-M-Y',strtotime($data_n->date));
				$row[] = $data_n->portfolio_title;
				$row[] = $data_n->company_name;
				$row[] = $data_n->company_address;
				$row[] = $data_n->publish_status;
				$row[] = $data_n->status;
				$row[] = $data_n->contact_person;
				$row[] = $data_n->contact_person_post;
				$row[] = $data_n->content;
				$row[] = $data_n->testimonial;
				$row[] = $data_n->tesimonial_status;
				$row[] = $data_n->picture;
				$row[] = sha1($data_n->portfolio_id  );
				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->TableModel->count_all(),
				"recordsFiltered" => $this->TableModel->count_filtered(),
				"data" => $data,
			);
			//output to json format
			echo json_encode($output);
		}
	}

	public function addPortfolioPicture(){
		if ($this->input->is_ajax_request()){
			$portfolio_id_sha1=$this->input->post('portfolio_id',TRUE);
			$result=$this->crud->getIDProcessing($portfolio_id_sha1,'portfolio_id','portfolio');
			$portfolio_id= $result->portfolio_id;

			$image_exist=$this->model->exist_image($portfolio_id);
			if($image_exist){
				unlink('assets/img/portfolio/'.$image_exist->picture);
			}
			$image_data=$this->input->post('image');
			list($type, $image_data) = explode(';', $image_data);
			list(, $image_data)      = explode(',', $image_data);
			$image_data = base64_decode($image_data);
			$imageName = time().'.png';
			file_put_contents('assets/img/portfolio/'.$imageName, $image_data);

			$dataSet=array(
				'picture'=>$imageName,
				'publish_status'=>"Published",
			);
			$table="portfolio";

			if($this->crud->updateData($portfolio_id,$dataSet,'portfolio_id',$table)){
				$data['response']='Picture Added successfully';
			}
			else{
				$data['response']='Error Occured';
			}
			echo json_encode($data);
		}
	}

	public function portfolioEditProcess(){
		if ($this->input->is_ajax_request())
		{
			$this->form_validation->set_rules('date','Date','required|trim');
			$this->form_validation->set_rules('portfolio_title','Portfolio title','required|trim');
			$this->form_validation->set_rules('company_name','company_name','required|trim');
			$this->form_validation->set_rules('company_address','company_address','required|trim');
			$this->form_validation->set_rules('content','content','required|trim');
			$check=$this->input->post('check',TRUE);
			if($check=='on'){
				$this->form_validation->set_rules('contact_person','contact_person','required|trim');
				$this->form_validation->set_rules('contact_person_post','contact_person_post','required|trim');
				$this->form_validation->set_rules('testimonial','Testimonial','required|trim');
			}
			$this->form_validation->set_rules('status','Status','required|trim');

			if($this->form_validation->run()){

				$portfolio_id_sha1=$this->input->post('portfolio_id',TRUE);
				$result=$this->crud->getIDProcessing($portfolio_id_sha1,'portfolio_id','portfolio');
				$portfolio_id= $result->portfolio_id;

				$date=$this->input->post('date',TRUE);
				$new_date=date("Y-m-d",strtotime(str_replace('/','-',$date)));
				$portfolio_title=$this->input->post('portfolio_title',TRUE);
				$company_name=$this->input->post('company_name',TRUE);
				$company_address=$this->input->post('company_address',TRUE);
				$content=$this->input->post('content',TRUE);
				$status=$this->input->post('status',TRUE);
				$url = strtolower(trim(str_replace(" ", "-", $portfolio_title)));
				$filtered_url = preg_replace('/[^A-Za-z0-9\-]/', '', $url);
				$filter_result = $this->model->exist_url($filtered_url,$portfolio_id);
				if($filter_result){
					if($check=='on'){
						$contact_person=$this->input->post('contact_person',TRUE);
						$contact_person_post=$this->input->post('contact_person_post',TRUE);
						$testimonial=$this->input->post('testimonial',TRUE);
						$testimonial_status='TRUE';
						$dataSet=array(
							'portfolio_title'=>$portfolio_title,
							'company_name'=>$company_name,
							'company_address'=>$company_address,
							'date'=>$new_date,
							'content'=>$content,
							'contact_person'=>$contact_person,
							'contact_person_post'=>$contact_person_post,
							'testimonial'=>$testimonial,
							'tesimonial_status'=>$testimonial_status,
							'status'=>$status,
							'url'=>$filtered_url
						);
					}
					else{
						$testimonial_status='FALSE';
						$dataSet=array(
							'portfolio_title'=>$portfolio_title,
							'company_name'=>$company_name,
							'company_address'=>$company_address,
							'date'=>$new_date,
							'content'=>$content,
							'contact_person'=>'',
							'contact_person_post'=>'',
							'testimonial'=>'',
							'tesimonial_status'=>$testimonial_status,
							'status'=>$status,
							'url'=>$filtered_url
						);
					}

					$table="portfolio";


					if($this->crud->updateData($portfolio_id,$dataSet,'portfolio_id',$table)){
						$data['response']='Portfolio update successfully';
						$data['type']='success';
					}
					else{
						$data['response']='Error Occured';
						$data['type']='error';
					}
				}
				else{
					$data['response']='Portfolio Already Exist';
					$data['type']='warning';
				}
			}
			else{
				$data['response']='Validation Error';
				$data['type']='error';
			}
			echo json_encode($data);
		}
	}
}
