<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ProductInquiryController extends CI_Controller
{


	public function __construct()
	{

		parent::__construct();

		if ($this->session->userdata('admin_logged_in') !== TRUE) {
			redirect('/');
		}

		$this->load->model('dataHandling/crud', 'crud');
		$this->load->model('pages/ProductInquiryModel', 'model');
		$this->load->model('TableModel/product_inquiry/FetchProductInquiryData', 'TableModel');
	}

	public function index()
	{
		$this->layouts->add_includes('assets/backend/js/pages/product_inquiry.js');
		$data['title'] = "Product Inquiry";
		$data['content'] = 'pages/main/product_inquiry';
		$this->load->view('layout/backend-access', $data);
	}



	public function getProductInquiryData()
	{
		if ($this->input->is_ajax_request()) {
			$list = $this->TableModel->get_datatables();
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {
				$no++;
				$row = array();
				$row[] = $no;
				$row[] = date('d-M-Y', strtotime($data_n->sended_at));
				$row[] = $data_n->user_name;
				$row[] = $data_n->user_phone;
				$row[] = $data_n->user_email;
				$row[] = $data_n->pr_name;
				$row[] = $data_n->seen_status;
				$row[] = $data_n->user_address;
				$row[] = $data_n->pr_id;
				$row[] = $data_n->pr_sub_cat_id;
				$row[] = $data_n->pr_quantity;
				$row[] = $data_n->message;
				$row[] = sha1($data_n->id);
				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->TableModel->count_all(),
				"recordsFiltered" => $this->TableModel->count_filtered(),
				"data" => $data,
			);
			//output to json format
			echo json_encode($output);
		}
	}

	public function updateProductInquiryStatus()
	{
		if ($this->input->is_ajax_request()) {
			$hash_id = $this->input->post('id');
			$result = $this->model->getIDProcessing($hash_id);
			$dataSet = [
				'seen_status' => 'Seen'
			];
			$table = "quoation_inquiry";
			if ($this->crud->updateData($result->id, $dataSet, 'id', $table)) {
				$data['response'] = 'Status updated';
			} else {
				$data['response'] = 'Error Occured';
			}
			echo json_encode($data);
		}
	}
}
