<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class SubCategoryController extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('admin_logged_in')!==TRUE){
			redirect('/');
		}

		$this->load->model('dataHandling/crud','crud');
		$this->load->model('pages/CategoryModel','model');
		$this->load->model('TableModel/category/FetchSubCategoryData','TableModel');

	}
	public function index(){
		$this->layouts->add_includes('assets/backend/js/pages/subcategory.js');
		$data['title']="Sub Category";
		$data['content']='pages/main/subcategory';
		$this->load->view('layout/backend-access',$data);
	}

	public function getSubCategoryData(){
		if ($this->input->is_ajax_request()){
			$list = $this->TableModel->get_datatables();
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {


				$no++;
				$row = array();
				$row[] = $no;
				$row[] = $data_n->sub_category_name;
				$row[] = $data_n->category_name;
				$row[] = $data_n->serial;
				$row[] = $data_n->status;
				$row[] = sha1($data_n->sub_category_id);
				$row[] = $data_n->category_id;


				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->TableModel->count_all(),
				"recordsFiltered" => $this->TableModel->count_filtered(),
				"data" => $data,
			);
			//output to json format
			echo json_encode($output);
		}
	}

	public function newSubCategoryEntryProcess(){
		if ($this->input->is_ajax_request())
		{
			$this->form_validation->set_rules('sub_category_name','Sub Category Name','required|trim');
			$this->form_validation->set_rules('category_id','Category Id','required|trim');
			$this->form_validation->set_rules('serial','Serial','required|trim');

			if($this->form_validation->run()){

				$sub_category_name=$this->input->post('sub_category_name',TRUE);
				$category_id=$this->input->post('category_id',TRUE);
				$serial=$this->input->post('serial',TRUE);

				$url = strtolower(trim(str_replace(" ", "-", $sub_category_name)));
				$filtered_url = preg_replace('/[^A-Za-z0-9\-]/', '', $url);
				$filter_result = $this->model->exist_sub_url($filtered_url);

				if($filter_result){
					$dataSet=array(
						'sub_category_name'=>$sub_category_name,
						'category_id'=>$category_id,
						'url'=>$filtered_url,
						'serial'=>$serial,
					);

					$table="sub_category";

					if($this->crud->insertReturnData($dataSet,$table)){
						$data['response']='Sub-Category save successfully';
						$data['type']='success';
					}
					else{
						$data['response']='Error Occured';
						$data['type']='error';
					}
				}
				else{
					$data['response']='Sub Category already exist';
					$data['type']='warning';
				}
			}
			else{
				$data['response']='Validation Error';
				$data['type']='error';
			}
			echo json_encode($data);
		}
	}

	public function subCategoryEditProcess(){
		if ($this->input->is_ajax_request())
		{
			$this->form_validation->set_rules('sub_category_name','Sub Category Name','required|trim');
			$this->form_validation->set_rules('category_id','Category Id','required|trim');
			$this->form_validation->set_rules('serial','Serial','required|trim');
			$this->form_validation->set_rules('status','Status','required|trim');

			if($this->form_validation->run()){

				$sub_category_id_sha1=$this->input->post('sub_category_id',TRUE);
				$result=$this->crud->getIDProcessing($sub_category_id_sha1,'sub_category_id','sub_category');
				$sub_category_id= $result->sub_category_id;

				$sub_category_name=$this->input->post('sub_category_name',TRUE);
				$category_id=$this->input->post('category_id',TRUE);
				$serial=$this->input->post('serial',TRUE);
				$status=$this->input->post('status',TRUE);
				$url = strtolower(trim(str_replace(" ", "-", $sub_category_name)));
				$filtered_url = preg_replace('/[^A-Za-z0-9\-]/', '', $url);
				$filter_result = $this->model->exist_sub_url($filtered_url,$sub_category_id);

				if($filter_result){
					$dataSet=array(
						'sub_category_name'=>$sub_category_name,
						'category_id'=>$category_id,
						'url'=>$filtered_url,
						'serial'=>$serial,
						'status'=>$status,
					);

					$table="sub_category";

					if($this->crud->updateData($sub_category_id,$dataSet,'sub_category_id',$table)){
						$data['response']='Sub-Category update successfully';
						$data['type']='success';
					}
					else{
						$data['response']='Error Occured';
						$data['type']='error';
					}
				}
				else{
					$data['response']='Sub-Category already exist';
					$data['type']='warning';
				}
			}
			else{
				$data['response']='Validation Error';
				$data['type']='error';
			}
			echo json_encode($data);
		}
	}

	public function getSubCategoryJsonData(){
		if ($this->input->is_ajax_request()){
			$category_id=$this->input->post('category_id',TRUE);
			$this->model->getSubCategoryJsonData($category_id);
		}
	}

	public function deleteSubCategory()
	{
		if ($this->input->is_ajax_request()) {
			$sub_category_id_sha1=$this->input->post('sub_category_id',TRUE);
			$result=$this->crud->getIDProcessing($sub_category_id_sha1,'sub_category_id','sub_category');
			$sub_category_id= $result->sub_category_id;
			$table = 'sub_category';

			$this->db->select('*');
			$this->db->where('sub_category_id',$sub_category_id);
			$query=$this->db->get('product');
			if($query->num_rows()>0){
				$data['response'] = 'Sorry! Reference in Product';
				$data['type'] = 'error';
			}
			else{
				if ($this->crud->deleteData($sub_category_id, 'sub_category_id', $table)) {
					$data['response'] = 'Deleted Successfully';
					$data['type'] = 'success';
				} else {
					$data['response'] = 'Error occurred';
					$data['type'] = 'error';
				}
			}
			echo json_encode($data);
		}
	}

}
