<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ContactController extends CI_Controller
{


	public function __construct()
	{

		parent::__construct();
		$this->load->model('frontend/MainModel', 'mainModel');
		$this->load->model('dataHandling/crud', 'crud');
	}


	public function index()
	{
		$this->layouts->add_includes('assets/js/pages/contact.js');
		$data['title'] = "Medisave Corporation";
		$data['content'] = 'pages/contact';
		$this->load->view('layout/main-layout', $data);
	}
	public function send_message()
	{
		if ($this->input->is_ajax_request()) {
			$this->form_validation->set_rules('sender_name', 'Sender Name', 'required|trim');
			$this->form_validation->set_rules('sender_contact', 'Sender Contact', 'required|trim');
			$this->form_validation->set_rules('sender_email', 'Sender Mail', 'required|trim');
			$this->form_validation->set_rules('subject', 'Subject', 'required|trim');
			$this->form_validation->set_rules('message', 'Message', 'required|trim');

			if ($this->form_validation->run()) {

				$sender_name = $this->input->post('sender_name', TRUE);
				$sender_contact = $this->input->post('sender_contact', TRUE);
				$sender_email = $this->input->post('sender_email', TRUE);
				$subject = $this->input->post('subject', TRUE);
				$message = $this->input->post('message', TRUE);

				$dataSet = array(
					'sender_name' => $sender_name,
					'sender_contact' => $sender_contact,
					'sender_email' => $sender_email,
					'subject' => $subject,
					'message' => $message,
				);
				$table = "contact";

				if ($this->crud->insertReturnData($dataSet, $table)) {
					$data['response'] = 'Message Send successfully Done';
				} else {
					$data['response'] = 'Error Occured';
				}
				$this->load->library('session');
				$this->session->set_userdata($dataSet);
				echo json_encode($data);
			}
		}
	}

	public function getLastMessage()
	{
		if ($this->input->is_ajax_request()) {
			if ($this->session->userdata('sender_name') != null) {
				$dataSet = array(
					'sender_name' => $this->session->userdata('sender_name'),
					'sender_contact' => $this->session->userdata('sender_contact'),
					'sender_email' => $this->session->userdata('sender_email'),
					'subject' => $this->session->userdata('subject'),
					'message' => $this->session->userdata('message'),
				);
			} else {
				$dataSet = "No message";
			}

			echo json_encode($dataSet);
		}
	}


	public function sendProductQuotationInquiry()
	{
		if ($this->input->is_ajax_request()) {
			$this->form_validation->set_rules('product_quantity', 'Product Quantity', 'required|trim');
			$this->form_validation->set_rules('user_name', 'Sender Contact', 'required|trim');
			$this->form_validation->set_rules('user_phone_number', 'Phone Number', 'required|numeric|min_length[11]|max_length[12]|trim');
			$this->form_validation->set_rules('user_email', 'Sender Mail', 'required|valid_email|trim');
			$this->form_validation->set_rules('user_address', 'Address Required', 'required|trim');
			$this->form_validation->set_rules('quotation_message', 'Message Required', 'required|trim');

			if ($this->form_validation->run()) {
				$product_id = $this->input->post('product_id', TRUE);
				$sub_cat_id = $this->input->post('sub_cat_id', TRUE);
				$product_name = $this->input->post('product_name', TRUE);
				$product_quantity = $this->input->post('product_quantity', TRUE);
				$user_name = $this->input->post('user_name', TRUE);
				$user_phone_number = $this->input->post('user_phone_number', TRUE);
				$user_email = $this->input->post('user_email', TRUE);
				$user_address = $this->input->post('user_address', TRUE);
				$quotation_message = $this->input->post('quotation_message', TRUE);

				$dataSet = array(
					'pr_id' => $product_id,
					'pr_sub_cat_id' => $sub_cat_id,
					'pr_name' => $product_name,
					'pr_quantity' => $product_quantity,
					'user_name' => $user_name,
					'user_phone' => $user_phone_number,
					'user_email' => $user_email,
					'user_address' => $user_address,
					'message' => $quotation_message,
				);

				$table = "quoation_inquiry";

				if ($this->crud->insertReturnData($dataSet, $table)) {
					$data['response'] = 'Inquiry Sended successfully';
				} else {
					$data['response'] = 'Error Occured';
				}
				echo json_encode($data);
			}
		}
	}
}
