<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PortfolioController extends CI_Controller{


	public function __construct() {

		parent::__construct();
		$this->load->model('frontend/MainModel','mainModel');
	}


	public function index(){
		$data['portfolio']=$this->mainModel->getAllPortfolio();
		$data['title']="Medisave Corporation";
		$data['content']='pages/portfolio';
		$this->load->view('layout/main-layout',$data);
	}


	public function portfolio($url){
		$portfolio=$this->mainModel->getSinglePortfolio($url);
		$data['portfolio']=$portfolio;
		$data['other_portfolio']=$this->mainModel->getOtherSinglePortfolio($portfolio->id);
		$data['title']="Medisave Corporation";
		$data['content']='pages/single_portfolio';
		$this->load->view('layout/main-layout',$data);
	}


}
