<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ProductController extends CI_Controller
{


	public function __construct()
	{

		parent::__construct();
		$this->load->model('frontend/ProductModel', 'productModel');
		$this->load->model('dataHandling/crud', 'crud');
		$this->layouts->add_includes('assets/js/pages/contact.js');
	}

	public function getCategoryProduct($category, $sub_category)
	{
		$data['product'] = $this->productModel->getProduct($category, $sub_category);
		$category_result = $this->productModel->getInfoByID('url', 'category', $category);
		$sub_category_result = $this->productModel->getInfoByID('url', 'sub_category', $sub_category);
		$data['br_title']='Category';
		$data['br_sub_title']='Category /  '.$category_result->category_name.' / '.$sub_category_result->sub_category_name;
		$data['title'] = "Medisave Corporation";
		$data['content'] = 'pages/product';
		$this->load->view('layout/main-layout', $data);
	}
	public function single_product($sub_category, $product)
	{
		$data['e']=TRUE;
		$product_info= $this->productModel->getSingleProduct($sub_category, $product);
		$data['product'] = $product_info;
		$data['related_product'] = $this->productModel->relatedProduct($product_info);
		$data['p_category'] = $this->productModel->getCategoryWiseProduct();
		$pr_result = $this->productModel->getInfoByID('url', 'product', $product);
		$sub_category_result = $this->productModel->getInfoByID('url', 'sub_category', $sub_category);
		$data['br_title']='Product';
		$data['br_sub_title']='Product /  '.$sub_category_result->sub_category_name.' / '.$pr_result->product_name;
		$data['title'] = "Medisave Corporation";
		$data['content'] = 'pages/single_product';
		$this->load->view('layout/main-layout', $data);
	}
	public function all_product()
	{
		if(isset($_POST) && !empty($_POST)){
			$product=$this->input->post('search_keyword');
			if($product!=""){
				$data['product'] =  $this->productModel->getFilterProduct($product);
			}
			else{
				$data['product'] = $this->productModel->getAllProduct();
			}
		}
		else{
			$data['product'] = $this->productModel->getAllProduct();
		}
		$data['br_title']='Product';
		$data['br_sub_title']='Product';
		$data['title'] = "Medisave Corporation";
		$data['content'] = 'pages/product';
		$this->load->view('layout/main-layout', $data);
	}
	public function all_product_json()
	{
		if ($this->input->is_ajax_request()) {
			$result = $this->productModel->getAllProduct();
			echo json_encode($result);
		}
	}
	public function allFeatureProductJson()
	{
		if ($this->input->is_ajax_request()) {
			$result = $this->productModel->getFeatureProduct();
			echo json_encode($result);
		}
	}
	public function allTopSaleProductJson()
	{
		if ($this->input->is_ajax_request()) {
			$result = $this->productModel->topSaleProduct();
			echo json_encode($result);
		}
	}


	public function getBrandProduct($brand)
	{
		$brand_result = $this->productModel->getInfoByID('url', 'brand', $brand);
		$data['br_title']='Brand';
		$data['br_sub_title']='Brand / '.$brand_result->brand_name;
		$data['product'] = $this->productModel->getBrandProduct($brand);
		$data['title'] = "Medisave Corporation";
		$data['content'] = 'pages/product';
		$this->load->view('layout/main-layout', $data);
	}
}
