<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MyAccount extends CI_Controller{


    public function __construct() {

        parent::__construct();

        if($this->session->userdata('client_logged_in')!==TRUE){

            redirect('/');

        }

        $this->load->model('dataHandling/crud','crud');
        $this->load->model('pages/AccountModel','AccountModel');

    }

    public function index(){
        $this->layouts->add_includes('assets/js/pages/profile.js');
        $data['title']="User Account";
        $data['content']='pages/main/profile';
        $this->load->view('layout/backend-access',$data);
    }
    public function changeUserPassword(){
        $this->layouts->add_includes('assets/js/pages/profile.js');
        $data['title']="Change Password";
        $data['content']='pages/main/changePassword';
        $this->load->view('layout/backend-access',$data);
    }
    

    public function getAccountProcessing(){
        if ($this->input->is_ajax_request())
        {
            $auth_user=$this->session->userdata('client_auth_id',TRUE);
            $this->AccountModel->getClientInfoProcessing($auth_user);
        }
        else{
            redirect('/');
        }

    }
    public function checkProfileUniqueEmail(){
        if ($this->input->is_ajax_request())
        {
            $email=$this->input->post('email');
            $auth_user=$this->session->userdata('client_auth_id',TRUE);
            $result=$this->AccountModel->checkProfileUniqueEmail($auth_user,$email);
            echo json_encode($result);
        }
        else{
            redirect('/');
        }
    }

    public function PostUpdateIntroducerProcessing(){

        if ($this->input->is_ajax_request())
        {
            $this->form_validation->set_rules('firstname','First Name','required|trim');
            $this->form_validation->set_rules('lastname','Last Name','required|trim');
            $this->form_validation->set_rules('email','Email','required|trim');

            if($this->form_validation->run()){

                $client_id=$this->session->userdata('client_auth_id',TRUE);


                $table='hcs_company_user';
                $where="client_id";


                $dataArray=array(

                    'firstname'=>$this->input->post('firstname',TRUE),
                    'lastname'=>$this->input->post('lastname',TRUE),
                    'email'=>$this->input->post('email',TRUE),
                    'ip_address'=>$this->input->ip_address(),
                    'last_modify'=>date('Y-m-d H:i:s'),

                );




                if($this->crud->updateData($client_id,$dataArray,$where,$table)){
                    $data = array(
                        'client_auth_user'=> $this->input->post('firstname',TRUE)." ".$this->input->post('lastname',TRUE),
                    );

                    $this->session->set_userdata($data);

                    if($this->input->post('email',TRUE)!=$this->session->userdata('client_auth_email',TRUE)){
                        $data['response']='email_change';
                    }
                    else{
                        $data['response']='update_succcessfully';
                    }

                    
                    echo json_encode($data);


                }

                else{

                    $data['response']='Error occurred';
                    echo json_encode($data);


                }


            }

        }

    }

    public function PostChangePassword(){

        if ($this->input->is_ajax_request())
        {
            $this->form_validation->set_rules('password','Password','required|trim');
            $this->form_validation->set_rules('confirmPassword','Change Password','required|trim');

            if($this->form_validation->run()){


                $client_id=$this->session->userdata('client_auth_id',TRUE);


                $table='hcs_company_user';
                $where="client_id";

                $password=$this->input->post('password',TRUE);
                $changePassword=$this->input->post('confirmPassword',TRUE);



                if($password==$changePassword){
                    $dataArray=array(
                        'password'=>md5($password),
                        'ip_address'=>$this->input->ip_address(),
                        'last_modify'=>date('Y-m-d H:i:s'),
                    );


                    if($this->crud->updateData($client_id,$dataArray,$where,$table)){
                        
                        $data['response']='update_password_succcessfully';
                        echo json_encode($data);
                    }

                    else{

                        $data['response']='Error occurred';
                        echo json_encode($data);
                    }

                }
                else{
                    $data['response']="Confirm Password doesn't match";
                    echo json_encode($data);
                }

            }
            else{

                $data['response']="Validation Error";
                echo json_encode($data);
            }

        }

    }

}