<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class OrderController extends CI_Controller{


    public function __construct() {

        parent::__construct();

        if($this->session->userdata('client_logged_in')!==TRUE){

            redirect('/');

        }

        $this->load->model('TableModel/orders/FetchAwaitingOrderData','TableModel');
        $this->load->model('pages/OrderModel','OrderModel');
    }

    public function waitingApprovalOrder(){
        $this->layouts->add_includes('assets/js/pages/waitingApprovalOrder.js');
        $data['title']="Order Delivery Awaiting";
        $data['content']='pages/main/waitingApprovalOrder';
        $this->load->view('layout/backend-access',$data);
    }

    public function awaitingOrder(){
        $this->layouts->add_includes('assets/js/pages/awaitingOrder.js');
        $data['title']="Order Delivery Awaiting";
        $data['content']='pages/main/awaitingOrder';
        $this->load->view('layout/backend-access',$data);
    }
    public function deliveredOrder(){
        $this->layouts->add_includes('assets/js/pages/deliveredOrder.js');
        $data['title']="Delivered Order";
        $data['content']='pages/main/deliveredOrder';
        $this->load->view('layout/backend-access',$data);
    }

    public function refferalOrderDetails($hash){
        if(!empty($hash)) {
            $company_id=$this->session->userdata('company_id',TRUE);
            if($this->OrderModel->validHashCheck($hash,$company_id)) {
                $this->layouts->add_includes('assets/js/report/print.js');
                $data['title']="Order Delivery Awaiting Details";
                $data['content']='pages/main/orderDetails';
                $data['order']=$this->OrderModel->getOrderDetails($hash,$company_id);
                $this->load->view('layout/backend-access',$data);
            }
            else{
                redirect('awaitingOrder');
            }

        }
        else{
            redirect('awaitingOrder');
        }
    }

    public function getAllOrderData()
    {

        if ($this->input->is_ajax_request()){
            $status=$this->input->post('status');
            $flag=$this->input->post('flag');
            $list = $this->TableModel->get_datatables($status,$flag);
            $data = array();
            $no = $_POST['start'];

            foreach ($list as $data_n) {


                $no++;
                $row = array();
                $row[] = $no;
                $row[] = date('d-F-Y',strtotime($data_n->created_date));
                $row[] = $data_n->total;
                $row[] = $data_n->discount_offer;
                $row[] = $data_n->discount_amount;
                $row[] = $data_n->grand_total;
                $row[] = $data_n->paid_amount;               
                $row[] = sha1($data_n->order_id);


                $data[] = $row;
            }

            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->TableModel->count_all($status,$flag),
                "recordsFiltered" => $this->TableModel->count_filtered($status,$flag),
                "data" => $data,
            );
            //output to json format
            echo json_encode($output);
        }

    }




}