<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PatientController extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('client_logged_in')!==TRUE){

			redirect('/');

		}

		$this->load->model('pages/PatientModel','PatientModel');
		$this->load->model('TableModel/Patient/FetchPatientData','TableModel');
		

	}

	public function index(){
		$this->layouts->add_includes('assets/js/pages/patientInfo.js');
		$data['title']="Patient Info";
		$data['content']='pages/main/patientInfo';
		$this->load->view('layout/backend-access',$data);
	}


	

	public function getPatientData()
	{

		if ($this->input->is_ajax_request()){

			$id=$this->session->userdata('company_id',TRUE);

			$list = $this->TableModel->get_datatables($id);
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {


				$no++;
				$row = array();
				$row[] = $no;
				$row[] = $data_n->patient_tracking_no;
				$row[] = $data_n->name;
				$row[] = $data_n->gender;
				$row[] = $data_n->date_of_birth;
				$row[] = $data_n->email;
				$row[] = $data_n->contact_no;
				$row[] = $data_n->address;
				$row[] = $data_n->total_test;
				$row[] = $data_n->firstname;
				$row[] = $data_n->lastname;
				$row[] = sha1($data_n->employee_id);
				             

				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->TableModel->count_all($id),
				"recordsFiltered" => $this->TableModel->count_filtered($id),
				"data" => $data,
			);
            //output to json format
			echo json_encode($output);
		}

	}


	public function getPatientsAllTestData(){
		if ($this->input->is_ajax_request()){
			$patient_id=$this->input->post('patient_id');
			$this->PatientModel->getPatientsAllTestData($patient_id);
		}
	}

}