<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ScheduleController extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('client_logged_in')!==TRUE){

			redirect('/');

		}

		$this->load->model('dataHandling/crud','crud');
		$this->load->model('TableModel/Schedule/FetchActiveScheduleData','ActiveScheduleTableModel');
		$this->load->model('TableModel/Schedule/FetchArchiveScheduleData','ArchiveScheduleTableModel');
		

	}

	public function activeRetestSchedule(){
		$this->layouts->add_includes('assets/js/pages/activeSchedule.js');
		$data['title']="Active Re-Test Schedule";
		$data['content']='pages/main/activeSchedule';
		$this->load->view('layout/backend-access',$data);
	}

	public function archiveRetestSchedule(){
		$this->layouts->add_includes('assets/js/pages/archiveSchedule.js');
		$data['title']="Archive Re-Test Schedule";
		$data['content']='pages/main/archiveSchedule';
		$this->load->view('layout/backend-access',$data);
	}


	public function assignNewRetestDate(){
		if ($this->input->is_ajax_request()){
			$this->form_validation->set_rules('new_retest_date','Re-Test Date','required|trim');
			if($this->form_validation->run()){
				$test_id=$this->input->post('test_id',TRUE);
				$retest_date=$this->input->post('new_retest_date',TRUE);

				$result=$this->getTestIDProcessing($test_id);
				$testID=$result->test_id;


				$dataSet=array(
					'retest_date'=>$retest_date,	
				);


				$table="hcs_test";


				if($this->crud-> updateData($testID,$dataSet,"test_id",$table)){
					
					$data['response']='update_succcessfully';
				}
				else{
					$data['response']='Error Occured';
				}

				echo json_encode($data);
			}
		}
	}
	
	public function getTestIDProcessing($id) {
        $this->db->select("test_id");
        $this->db->where('sha1(test_id)',$id);
        $query = $this->db->get('hcs_test');
        return $query->row();
    }

	public function getEmployeeIDProcessing($id) {
        $this->db->select("employee_id");
        $this->db->where('sha1(employee_id)',$id);
        $query = $this->db->get('hcs_test');
        return $query->row();
    }
    
	

	public function getactiveScheduleData()
	{

		if ($this->input->is_ajax_request()){

			$id=$this->session->userdata('company_id',TRUE);

			$list = $this->ActiveScheduleTableModel->get_datatables($id);
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {


				$no++;
				$row = array();
				$row[] = $no;
				$row[] = $data_n->retest_date;
				$row[] = $data_n->test_type;
				$row[] = $data_n->test_date;
				$row[] = $data_n->patient_tracking_no;
				$row[] = $data_n->name;
				$row[] = $data_n->result;
				$row[] = $data_n->confirmed_case;
				$row[] = $data_n->specimen;
				$row[] = $data_n->self_isolation_recomanded;
				$row[] = $data_n->rt_pcr;
				$row[] = sha1($data_n->employee_id);
				$row[] = sha1($data_n->test_id);


				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->ActiveScheduleTableModel->count_all($id),
				"recordsFiltered" => $this->ActiveScheduleTableModel->count_filtered($id),
				"data" => $data,
			);
            //output to json format
			echo json_encode($output);
		}

	}

	public function getarchiveScheduleData()
	{

		if ($this->input->is_ajax_request()){

			$id=$this->session->userdata('company_id',TRUE);

			$list = $this->ArchiveScheduleTableModel->get_datatables($id);
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {


				$no++;
				$row = array();
				$row[] = $no;
				$row[] = $data_n->retest_date;
				$row[] = $data_n->test_type;
				$row[] = $data_n->test_date;
				$row[] = $data_n->patient_tracking_no;
				$row[] = $data_n->name;
				$row[] = $data_n->result;
				$row[] = $data_n->confirmed_case;
				$row[] = $data_n->specimen;
				$row[] = $data_n->self_isolation_recomanded;
				$row[] = $data_n->rt_pcr;
				$row[] = sha1($data_n->employee_id);
				$row[] = sha1($data_n->test_id);


				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->ArchiveScheduleTableModel->count_all($id),
				"recordsFiltered" => $this->ArchiveScheduleTableModel->count_filtered($id),
				"data" => $data,
			);
            //output to json format
			echo json_encode($output);
		}

	}

	

}