<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/Postcode.php';


class TestController extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('client_logged_in')!==TRUE){

			redirect('/');

		}

		$this->load->model('dataHandling/crud','crud');
		$this->load->model('pages/TestModel','TestModel');
		$this->load->model('TableModel/Test/FetchTestData','TableModel');
		

	}

	public function index(){
		$this->layouts->add_includes('assets/js/pages/testEntry.js');
		$data['title']="Test Entry";
		$data['content']='pages/main/testEntry';
		$this->load->view('layout/backend-access',$data);
	}

	public function reTestEntry(){
		$this->layouts->add_includes('assets/js/pages/reTestEntry.js');
		$data['title']="Re-Test Entry";
		$data['content']='pages/main/reTestEntry';
		$this->load->view('layout/backend-access',$data);
	}
	
	private function getLoc($post_code_input){
		$postcode = new Postcode();
		$lookup = $postcode->lookup($post_code_input);
		
		if($lookup){
			$latitude= $lookup->latitude;
			$longitude= $lookup->longitude;
		}
		else{
			$latitude= NULL;
			$longitude= NULL;
		}

		$data=array(
			'latitude' => $latitude,
			'longitude' => $longitude
		);

		return $data;
	}

	public function getLatLog(){
		if ($this->input->is_ajax_request()) 
		{

			$post_code=$this->input->get('post_code');
			$geoLoc=$this->getLoc($post_code);
			
			$lat= $geoLoc['latitude'];
			$log= $geoLoc['longitude'];

			$data=array(
				'lat'=>$lat,
				'log'=>$log
			);

			echo json_encode($data);
		}
		
	}


	public function newTestEntryProcess(){
		if ($this->input->is_ajax_request()) 
		{
			$choose_one=$this->input->post('choose_one',TRUE);
			$this->form_validation->set_rules('firstname','First Name','required|trim');
			$this->form_validation->set_rules('lastname','Last Name','required|trim');
			$this->form_validation->set_rules('gender','Gender','required|trim');
			$this->form_validation->set_rules('date_of_birth','Date of Birth','required|trim');
			$this->form_validation->set_rules('email','Email','required|trim|is_unique[hcs_employee.email]');
			$this->form_validation->set_rules('contact_no','Contact','required|trim');
			$this->form_validation->set_rules('employee_no','Employee Number','required|trim');
			$this->form_validation->set_rules('payroll_no','Payroll Number','required|trim');
			$this->form_validation->set_rules('nin','National Insurence Number','required|trim');
			if($choose_one==1){
				$this->form_validation->set_rules('driving_license','Driving License','required|trim');
			}
			else if($choose_one==2){
				$this->form_validation->set_rules('passport','Passport','required|trim');
			}
			$this->form_validation->set_rules('address','Address','required|trim');
			$this->form_validation->set_rules('post_code','Post Code','required|trim');
			$this->form_validation->set_rules('temperature','Temperature','required|trim');
			$this->form_validation->set_rules('test_type','Test Type','required|trim');
			$this->form_validation->set_rules('test_date','Test Type','required|trim');
			$this->form_validation->set_rules('result','Result','required|trim');
			$this->form_validation->set_rules('specimen','Specimen','required|trim');
			$this->form_validation->set_rules('confirmed_case','Confirmed Case','required|trim');
			$this->form_validation->set_rules('self_isolation_recomanded','Isolation','required|trim');
			$this->form_validation->set_rules('rt_pcr','RT PCR','required|trim');
			$this->form_validation->set_rules('retest','Retest','required|trim');


			if($this->form_validation->run()){

				$firstname=$this->input->post('firstname',TRUE);
				$lastname=$this->input->post('lastname',TRUE);
				$gender=$this->input->post('gender',TRUE);
				$date_of_birth=$this->input->post('date_of_birth',TRUE);
				$email=$this->input->post('email',TRUE);
				$contact_no=$this->input->post('contact_no',TRUE);
				$employee_no=$this->input->post('employee_no',TRUE);
				$payroll_no=$this->input->post('payroll_no',TRUE);
				$nin=$this->input->post('nin',TRUE);
				if($choose_one==1){
					$driving_license=$this->input->post('driving_license',TRUE);
					$passport=NULL;
				}
				else if($choose_one==2){
					$passport=$this->input->post('passport',TRUE);
					$driving_license=NULL;
				}
				$address=$this->input->post('address',TRUE);
				$post_code=$this->input->post('post_code',TRUE);

				$lat= $this->input->post('lat',TRUE);
				$log= $this->input->post('log',TRUE);

				$temperature=$this->input->post('temperature',TRUE);
				$test_type=$this->input->post('test_type',TRUE);
				$test_date=$this->input->post('test_date',TRUE);
				$test_result=$this->input->post('result',TRUE);
				$specimen=$this->input->post('specimen',TRUE);
				$ip_address=$this->input->ip_address();
				$client_id=$this->session->userdata('client_auth_id',TRUE);
				$confirmed_case=$this->input->post('confirmed_case',TRUE);
				$self_isolation_recomanded=$this->input->post('self_isolation_recomanded',TRUE);
				$rt_pcr=$this->input->post('rt_pcr',TRUE);
				$retest=$this->input->post('retest',TRUE);

				if($retest=='No'){
					$retest_date=NULL;
				}
				else if($retest=='Yes'){
					$retest_date=$this->input->post('retest_date',TRUE);
				}
				$company_id=$this->session->userdata('company_id',TRUE);
				$patient_tracking_no=$this->TestModel->getPatientTrackingNo($company_id);
				$dataSet=array(
					'patient_tracking_no'=>$patient_tracking_no,
					'firstname'=>$firstname,
					'lastname'=>$lastname,
					'gender'=>$gender,
					'date_of_birth'=>$date_of_birth,
					'driving_license'=>$driving_license,
					'passport'=>$passport,
					'nin'=>$nin,
					'employee_number'=>$employee_no,
					'payroll_number'=>$payroll_no,
					'address'=>$address,
					'post_code'=>$post_code,
					'lat'=>$lat,
					'log'=>$log,
					'contact_no'=>$contact_no,
					'email'=>$email,
					'ip_address'=>$ip_address,
					'company_id'=>$company_id,
				);

				$table="hcs_employee";

				if($employee_id=$this->crud->insertReturnData($dataSet,$table)){
					$dataSet=array(
						'employee_id'=>$employee_id,
						'temperature'=>$temperature,
						'test_type'=>$test_type,
						'test_date'=>$test_date,
						'result'=>$test_result,
						'specimen'=>$specimen,
						'confirmed_case'=>$confirmed_case,
						'retest'=>$retest,
						'retest_date'=>$retest_date,
						'self_isolation_recomanded'=>$self_isolation_recomanded,
						'rt_pcr'=>$rt_pcr,
						'client_id'=>$client_id,
						'company_id'=>$company_id,
					);


					$table="hcs_test";

					if($this->crud->insertReturnData($dataSet,$table)){
						$data['response']='Test save successfully';
					}
					else{
						$data['response']='Error Occured';
					}

					echo json_encode($data);
				}
				else{
					$data['response']='Error Occured';
					echo json_encode($data);
				}

			}
			else{
				$data['response']='Validation Error';
				echo json_encode($data);
			}
		}
	}




	public function reTestEntryProcess(){
		if ($this->input->is_ajax_request()) 
		{
			
			$this->form_validation->set_rules('firstname','First Name','required|trim');
			$this->form_validation->set_rules('temperature','Temperature','required|trim');
			$this->form_validation->set_rules('test_type','Test Type','required|trim');
			$this->form_validation->set_rules('test_date','Test Type','required|trim');
			$this->form_validation->set_rules('result','Result','required|trim');
			$this->form_validation->set_rules('specimen','Specimen','required|trim');
			$this->form_validation->set_rules('confirmed_case','Confirmed Case','required|trim');
			$this->form_validation->set_rules('self_isolation_recomanded','Isolation','required|trim');
			$this->form_validation->set_rules('rt_pcr','RT PCR','required|trim');
			$this->form_validation->set_rules('retest','Retest','required|trim');


			if($this->form_validation->run()){
				$employee_id_from_ui=$this->input->post('employee_id',TRUE);
				$temperature=$this->input->post('temperature',TRUE);
				$test_type=$this->input->post('test_type',TRUE);
				$test_date=$this->input->post('test_date',TRUE);
				$test_result=$this->input->post('result',TRUE);
				$specimen=$this->input->post('specimen',TRUE);
				$ip_address=$this->input->ip_address();
				$client_id=$this->session->userdata('client_auth_id',TRUE);
				$confirmed_case=$this->input->post('confirmed_case',TRUE);
				$self_isolation_recomanded=$this->input->post('self_isolation_recomanded',TRUE);
				$rt_pcr=$this->input->post('rt_pcr',TRUE);
				$retest=$this->input->post('retest',TRUE);

				if($retest=='No'){
					$retest_date=NULL;
				}
				else if($retest=='Yes'){
					$retest_date=$this->input->post('retest_date',TRUE);
				}

				
				$company_id=$this->session->userdata('company_id',TRUE);
				$responseData=$this->TestModel->getIDProcessing($employee_id_from_ui);
				$employee_id=$responseData->employee_id;

				

				$dataSet=array(
					'employee_id'=>$employee_id,
					'temperature'=>$temperature,
					'test_type'=>$test_type,
					'test_date'=>$test_date,
					'result'=>$test_result,
					'specimen'=>$specimen,
					'confirmed_case'=>$confirmed_case,
					'retest'=>$retest,
					'retest_date'=>$retest_date,
					'self_isolation_recomanded'=>$self_isolation_recomanded,
					'rt_pcr'=>$rt_pcr,
					'client_id'=>$client_id,
					'company_id'=>$company_id,
					
				);


				$table="hcs_test";

				if($this->crud->insertReturnData($dataSet,$table)){
					$data['response']='Test save successfully';
				}
				else{
					$data['response']='Error Occured';
				}

				echo json_encode($data);

			}
			else{
				$data['response']='Error Occured';
				echo json_encode($data);
			}
		}
	}
	public function getTestData()
	{

		if ($this->input->is_ajax_request()){

			$company_id=$this->session->userdata('company_id',TRUE);

			$list = $this->TableModel->get_datatables($company_id);
			$data = array();
			$no = $_POST['start'];

			foreach ($list as $data_n) {


				$no++;
				$row = array();
				$row[] = $no;
				$row[] = $data_n->test_date;
				$row[] = $data_n->patient_tracking_no;
				$row[] = $data_n->name;
				$row[] = $data_n->temperature;
				$row[] = $data_n->test_type;
				$row[] = $data_n->result;
				$row[] = $data_n->specimen;
				$row[] = $data_n->confirmed_case;
				$row[] = $data_n->self_isolation_recomanded;               
				$row[] = $data_n->rt_pcr;
				$row[] = $data_n->retest;
				$row[] = $data_n->retest_date;
				$row[] = $data_n->client_id;
				$row[] = $data_n->employee_id;
				$row[] = $data_n->gender;
				$row[] = $data_n->date_of_birth;
				$row[] = $data_n->address;
				$row[] = $data_n->contact_no;
				$row[] = $data_n->email;
				$row[] = $data_n->firstname;
				$row[] = $data_n->lastname;
				$row[] = $data_n->post_code;
				$row[] = $data_n->nin;
				$row[] = $data_n->driving_license;
				$row[] = $data_n->passport;
				$row[] = $data_n->employee_number;
				$row[] = $data_n->payroll_number;
				$data[] = $row;
			}

			$output = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $this->TableModel->count_all($company_id),
				"recordsFiltered" => $this->TableModel->count_filtered($company_id),
				"data" => $data,
			);
            //output to json format
			echo json_encode($output);
		}

	}

	public function checkUniqueEmail(){
		if ($this->input->is_ajax_request())
		{
			$this->form_validation->set_rules('email','Email','required|trim|valid_email|is_unique[hcs_employee.email]');
			if($this->form_validation->run()){
				echo 'true';
			}
			else{
				echo 'false';
			}
		}
	}

	public function alredyTestedEmployeeData(){
		if ($this->input->is_ajax_request()) 
		{
			$company_id=$this->session->userdata('company_id',TRUE);
			$this->TestModel->getEmployeeInfoProcessing($company_id);
		}
	}
	public function oneTestedEmployeeData(){
		if ($this->input->is_ajax_request()) 
		{
			$company_id=$this->session->userdata('company_id',TRUE);
			$employee_id=$this->input->get('employee_id');
			$this->TestModel->getOneEmployeeInfoProcessing($employee_id,$company_id);
		}
	}
	



}