<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class OrderReportController extends CI_Controller{

	public function __construct() {
		parent::__construct();

		if($this->session->userdata('client_logged_in')!==TRUE){
			redirect('/');
		}
		$this->load->model('report/OrderReportModel','ReportModel');

	}

	public function index(){
		$this->layouts->add_includes('assets/js/report/orderReport.js');
		$data['title']="Order Report";
		$data['content']='report/report_layout/orderReport';
		$this->load->view('layout/backend-access',$data);
	}

	public function dailyReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Daily Order Report";
		$data['content']='report/report_pages/orderReport';
		$data['report_date']=$this->input->get('date');
		$data['report_head']='Daily Order Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['order']=$this->ReportModel->dailyOrderReport($data['report_date'],$company_id);
		
		$this->load->view('layout/reportPage-layout',$data);
	}
	public function dateRangeReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Date Range Order Report";
		$data['content']='report/report_pages/orderReport';
		$start_date=$this->input->get('start_date');
		$end_date=$this->input->get('end_date');
		$data['report_date']=$start_date." to ".$end_date;
		$data['report_head']='Date Range Order Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['order']=$this->ReportModel->dateRangeOrderReport($start_date,$end_date,$company_id);
		$this->load->view('layout/reportPage-layout',$data);
	}
	public function monthlyReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Monthly Order Report";
		$data['content']='report/report_pages/orderReport';
		$month=$this->input->get('month');
		$year=$this->input->get('year');
		$data['report_date']=date('F',strtotime('01-'.$month.'-2020')).", ".$year;
		$data['report_head']='Monthly Order Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['order']=$this->ReportModel->monthlyOrderReport($month,$year,$company_id);
		$this->load->view('layout/reportPage-layout',$data);
	}

	public function yearlyReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Yearly Order Report";
		$data['content']='report/report_pages/orderReport';
		$year=$this->input->get('year');
		$data['report_date']=$year;
		$data['report_head']='Yearly Order Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['order']=$this->ReportModel->yearlyOrderReport($year,$company_id);
		$this->load->view('layout/reportPage-layout',$data);
	}
	

}