<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PatientReportController extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('client_logged_in')!==TRUE){

			redirect('/');

		}

		$this->load->model('report/PatientReportModel','ReportModel');

	}

	public function index(){
		$this->layouts->add_includes('assets/js/report/patientReport.js');
		$data['title']="Patient Report";
		$data['content']='report/report_layout/patientReport';
		$this->load->view('layout/backend-access',$data);
	}

	public function singlePatientReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Patient Report";
		$data['content']='report/report_pages/patientReport';
		$patient_id=$this->input->get('patient_id');
		$data['report_head']='Patient Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['master']=$this->ReportModel->getSinglePatientData($patient_id,$company_id);
		$data['test_details']=$this->ReportModel->getSinglePatientTestData($patient_id);
		$this->load->view('layout/reportPage-layout',$data);
	}
	public function allPatientReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Patient Report";
		$data['content']='report/report_pages/allPatientReport';
		$data['report_head']='All Patient Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['patient']=$this->ReportModel->getAllPatientData($company_id);
		$this->load->view('layout/reportPage-layout',$data);
	}
	

}