<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class RetestReportController extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('client_logged_in')!==TRUE){

			redirect('/');

		}

		$this->load->model('report/RetestReportModel','ReportModel');

	}

	public function index(){
		$this->layouts->add_includes('assets/js/report/retestReport.js');
		$data['title']="Re-Test Report";
		$data['content']='report/report_layout/retestReport';
		$this->load->view('layout/backend-access',$data);
	}

	public function dailyReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Daily Re-Test Report";
		$data['content']='report/report_pages/retestReport';
		$data['report_date']=$this->input->get('date');
		$data['report_head']='Daily Re-Test Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['report']=$this->ReportModel->dailyTestReport($data['report_date'],$company_id);
		$this->load->view('layout/reportPage-layout',$data);
	}
	public function dateRangeReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Date Range Re-Test Report";
		$data['content']='report/report_pages/retestReport';
		$start_date=$this->input->get('start_date');
		$end_date=$this->input->get('end_date');
		$data['report_date']=$start_date." to ".$end_date;
		$data['report_head']='Date Re-Range Test Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['report']=$this->ReportModel->dateRangeTestReport($start_date,$end_date,$company_id);
		$this->load->view('layout/reportPage-layout',$data);
	}
	public function monthlyReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Monthly Re-Test Report";
		$data['content']='report/report_pages/retestReport';
		$month=$this->input->get('month');
		$year=$this->input->get('year');
		$data['report_date']=date('F',strtotime('01-'.$month.'-2020')).", ".$year;
		$data['report_head']='Monthly Re-Test Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['report']=$this->ReportModel->monthlyTestReport($month,$year,$company_id);
		$this->load->view('layout/reportPage-layout',$data);
	}

	public function yearlyReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Yearly Re-Test Report";
		$data['content']='report/report_pages/retestReport';
		$year=$this->input->get('year');
		$data['report_date']=$year;
		$data['report_head']='Yearly Re-Test Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['report']=$this->ReportModel->yearlyTestReport($year,$company_id);
		$this->load->view('layout/reportPage-layout',$data);
	}
	

}