<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class TestReportController extends CI_Controller{


	public function __construct() {

		parent::__construct();

		if($this->session->userdata('client_logged_in')!==TRUE){

			redirect('/');

		}

		$this->load->model('report/TestReportModel','ReportModel');

	}

	public function index(){
		$this->layouts->add_includes('assets/js/report/testReport.js');
		$data['title']="Test Report";
		$data['content']='report/report_layout/testReport';
		$this->load->view('layout/backend-access',$data);
	}

	public function dailyReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Daily Test Report";
		$data['content']='report/report_pages/testReport';
		$data['report_date']=$this->input->get('date');
		$result=$this->input->get('result');
		$data['result_type']=$result;
		$data['report_head']='Daily Test Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['report']=$this->ReportModel->dailyTestReport($data['report_date'],$company_id,$result);
		$this->load->view('layout/reportPage-layout',$data);
	}
	public function dateRangeReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Date Range Test Report";
		$data['content']='report/report_pages/testReport';
		$start_date=$this->input->get('start_date');
		$end_date=$this->input->get('end_date');
		$result=$this->input->get('result');
		$data['result_type']=$result;
		$data['report_date']=$start_date." to ".$end_date;
		$data['report_head']='Date Range Test Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['report']=$this->ReportModel->dateRangeTestReport($start_date,$end_date,$company_id,$result);
		$this->load->view('layout/reportPage-layout',$data);
	}
	public function monthlyReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Monthly Test Report";
		$data['content']='report/report_pages/testReport';
		$month=$this->input->get('month');
		$year=$this->input->get('year');
		$result=$this->input->get('result');
		$data['result_type']=$result;
		$data['report_date']=date('F',strtotime('01-'.$month.'-2020')).", ".$year;
		$data['report_head']='Monthly Test Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['report']=$this->ReportModel->monthlyTestReport($month,$year,$company_id,$result);
		$this->load->view('layout/reportPage-layout',$data);
	}

	public function yearlyReport(){
		$this->layouts->add_includes('assets/js/report/print.js');
		$data['title']="Yearly Test Report";
		$data['content']='report/report_pages/testReport';
		$year=$this->input->get('year');
		$result=$this->input->get('result');
		$data['result_type']=$result;
		$data['report_date']=$year;
		$data['report_head']='Yearly Test Report';
		$company_id=$this->session->userdata('company_id',TRUE);
		$data['report']=$this->ReportModel->yearlyTestReport($year,$company_id,$result);
		$this->load->view('layout/reportPage-layout',$data);
	}
	

}