<?php
defined('BASEPATH') or exit('No direct script access allowed');

class FetchProductData extends CI_Model
{

	var $table = 'product';
	var $column_order = array(null, 'contact_no', 'email', 'address'); //set column field database for datatable orderable
	var $column_search =
	array('product_name', 'product_model', 'category_name', 'sub_category_name'); //set column field database for datatable searchable
	var $order = array('product_id' => 'desc'); // default order

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	private function _get_datatables_query()
	{
		$this->db->select("a.product_id, a.`product_name`, a.`product_model`, a.`size`, a.`description`, a.`presentation_status`, a.`status`, a.`availability`, a.`publish_status`,a.picture, b.category_name,c.sub_category_name,a.category_id,a.sub_category_id,a.`brand_id`, d.`brand_name`,a.tag,a.meta_description");
		$this->db->join('category as b', 'a.category_id = b.category_id', 'left');
		$this->db->join('sub_category as c', 'a.sub_category_id = c.sub_category_id AND c.category_id=b.category_id', 'left');
		$this->db->join('brand as d', 'a.brand_id = d.brand_id', 'left');
		$this->db->order_by("product_id", "DESC");
		$this->db->from('product as a');


		$i = 0;

		foreach ($this->column_search as $item) // loop column
		{
			if ($_POST['search']['value']) // if datatable send POST for search
			{

				if ($i === 0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				} else {
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if (count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if (isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} else if (isset($this->order)) {
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	function get_datatables()
	{
		$this->_get_datatables_query();
		if ($_POST['length'] != -1)
			$this->db->limit($_POST['length'], $_POST['start']);

		$query = $this->db->get();
		return $query->result();
	}

	function count_filtered()
	{
		$this->_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->from($this->table);
		return $this->db->count_all_results();
	}
}
