<?php
defined('BASEPATH') or exit('No direct script access allowed');

class MainModel extends CI_Model
{

	public function getProduct($category_hash, $sub_category_hash)
	{

		$this->db->select("sha1(a.product_id) as product_id, a.`product_name`, a.`product_model`, a.`product_price`, a.`price_currency`,a.`size`, a.`description`, a.`presentation_status`, a.`status`, a.`availability`, a.`publish_status`,a.picture,b.category_name,c.sub_category_name,d.manufacturer_name,e.uom,a.category_id,sha1(a.sub_category_id) as sub_category_id,a.uom_id,a.manufacturer_id");
		$this->db->join('category as b', 'a.category_id = b.category_id', 'left');
		$this->db->join('sub_category as c', 'a.sub_category_id = c.sub_category_id AND c.category_id=b.category_id', 'left');
		$this->db->join('manufacturer as d', 'a.manufacturer_id = d.manufacturer_id', 'left');
		$this->db->join('uom as e', 'a.uom_id = e.uom_id', 'left');
		$this->db->where('sha1(a.category_id)', $category_hash);
		$this->db->where('sha1(a.sub_category_id)', $sub_category_hash);
		$this->db->where('a.status', 'Active');
		$this->db->where('a.availability', 'Available');
		$this->db->where('a.publish_status', 'Published');
		$this->db->order_by("a.product_id", "DESC");
		$this->db->from('product as a');
		$query = $this->db->get();
		return $query->result_array();
	}

	public function getBrand()
	{
		$this->db->select("b.brand_name,b.logo,b.url,b.serial");
		$this->db->where('b.status', 'Active');
		$this->db->where('b.publish_status', 'Published');
		$this->db->where('p.brand_id = b.brand_id');
		$this->db->group_by('b.brand_name,b.logo,b.url,b.serial');
		$this->db->order_by('b.serial', 'ASC');
		$query = $this->db->get('brand b, product p');
		return $query->result_array();
	}

	public function getAllPortfolio()
	{
		$this->db->select("sha1(portfolio_id) as id,`portfolio_title`, url, `company_name`, `company_address`, `contact_person`, `contact_person_post`, `testimonial`, `tesimonial_status`, `date`, `content`, `picture`");
		$this->db->where('status', 'Active');
		$this->db->where('publish_status', 'Published');
		$this->db->order_by('date', 'DESC');
		$query = $this->db->get('portfolio');
		return $query->result_array();
	}

	public function getSinglePortfolio($url)
	{
		$this->db->select("sha1(portfolio_id) as id,`portfolio_title`, `company_name`, `company_address`, `contact_person`, `contact_person_post`, `testimonial`, `tesimonial_status`, `date`, `content`, `picture`");
		$this->db->where('url', $url);
		$this->db->where('status', 'Active');
		$this->db->where('publish_status', 'Published');
		$this->db->order_by('date', 'DESC');
		$query = $this->db->get('portfolio');
		return $query->row();
	}
	public function getOtherSinglePortfolio($hash_id)
	{
		$this->db->select("sha1(portfolio_id) as id,`portfolio_title`, url, `company_name`, `company_address`, `contact_person`, `contact_person_post`, `testimonial`, `tesimonial_status`, `date`, `content`, `picture`");
		$this->db->where_not_in('sha1(portfolio_id)', $hash_id);
		$this->db->where('status', 'Active');
		$this->db->where('publish_status', 'Published');
		$this->db->order_by('date', 'DESC');
		$this->db->limit(10);
		$query = $this->db->get('portfolio');
		return $query->result_array();
	}

	public function getGallery(){
		$this->db->select(" `picture`");
		$this->db->order_by('gallery_id', 'DESC');
		$query = $this->db->get('gallery');
		return $query->result_array();
	}
	public function getTeam(){
		$this->db->select("*");
		$this->db->where("status","Active");
		$this->db->order_by('serial', 'ASC');
		$query = $this->db->get('team');
		return $query->result_array();
	}
}
