<?php
defined('BASEPATH') or exit('No direct script access allowed');

class BrandModel extends CI_Model
{

	public function exist_image($brand_id)
	{
		$this->db->select("logo");
		$this->db->where('brand_id', $brand_id);
		$query = $this->db->get('brand');
		return $query->row();
	}
	public function getBrand()
	{
		$this->db->select(" sha1(`brand_id`) as brand_id, `brand_name`");
		$this->db->where('status', 'Active');
		$this->db->order_by('brand_name', 'ASC');
		$query = $this->db->get('brand');
		return $query->result_array();
	}
	public function getBrandofProduct()
	{
		$this->db->select(" sha1(b.brand_id) as brand_id, b.brand_name,b.url,b.serial");
		$this->db->where('b.brand_id=p.brand_id');
		$this->db->where('b.status', 'Active');
		$this->db->group_by('sha1(b.brand_id), b.brand_name,b.url,b.serial');
		$this->db->order_by('b.serial', 'ASC');
		$query = $this->db->get('brand b, product p');
		return $query->result_array();
	}

	public function getBrandJsonData()
	{
		$this->db->select("*");
		$this->db->where('status', 'Active');
		$this->db->where('publish_status', 'Published');
		$this->db->order_by('brand_name  ', 'ASC');
		$query = $this->db->get('brand');
		echo json_encode($query->result_array());
	}

	public function exist_url($url, $id = null)
	{
		$this->db->where('Trim(LOWER(url))', $url);
		if ($id != null) {
			$this->db->where_not_in('brand_id', $id);
		}
		$query = $this->db->get('brand');
		$rs =  $query->num_rows();
		if ($rs > 0) {
			return false;
		} else {
			return true;
		}
	}
}
