<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class CategoryModel extends CI_Model{



	public function getCategoryInfo() {
		$this->db->select("*");
		$this->db->where('status','Active');
		$this->db->order_by('category_id','DESC');
		$query = $this->db->get('category');
		echo json_encode($query->result_array());
	}
	public function getSubCategoryJsonData($category_id){
		$this->db->select("*");
		$this->db->where('status','Active');
		$this->db->where('category_id',$category_id);
		$this->db->order_by('sub_category_id','DESC');
		$query = $this->db->get('sub_category');
		echo json_encode($query->result_array());
	}
	public function getCategory() {
		$this->db->select(" sha1(`category_id`) as category_id, `category_name`");
		$this->db->where('status','Active');
		$this->db->order_by('category_id','DESC');
		$query = $this->db->get('category');
		return $query->result_array();
	}
	public function getCategoryofProduct() {
		$this->db->select("sha1(c.category_id) as category_id,c.category_name,c.url,c.serial");
		$this->db->where('c.category_id = p.category_id');
		$this->db->where('c.status','Active');
		$this->db->group_by('sha1(category_id),c.category_name,c.url,c.serial');
		$this->db->order_by('c.serial','ASC');
		$query = $this->db->get('category c,product p');
		return $query->result_array();
	}
	public function getCategoryNav() {
		$this->db->select(" sha1(c.`category_id`) as category_id, c.`category_name`");
		$this->db->where('c.status','Active');
		$this->db->where('c.category_id = sc.category_id');
		$this->db->order_by('c.category_id','DESC');
		$this->db->group_by('c.category_id,category_name');
		$query = $this->db->get('category c, sub_category sc');
		return $query->result_array();
	}
	public function getSubCategory($category_id) {
		$this->db->select(" sha1(`sub_category_id`) as sub_category_id,sha1(`category_id`) as category_id, `sub_category_name`");
		$this->db->where('status','Active');
		$this->db->where('sha1(category_id)',$category_id);
		$this->db->order_by('sub_category_id','DESC');
		$query = $this->db->get('sub_category');
		return $query->result_array();
	}
	public function getSubCategoryofProduct($category_id) {
		$this->db->select("sha1(s.sub_category_id) as sub_category_id,sha1(s.category_id) as category_id, s.sub_category_name,s.serial,s.url");
		$this->db->where('s.sub_category_id = p.sub_category_id');
		$this->db->where('s.status','Active');
		$this->db->where('sha1(s.category_id)',$category_id);
		$this->db->group_by('sha1(s.sub_category_id),sha1(s.category_id), s.sub_category_name,s.serial,s.url');
		$this->db->order_by('s.serial','ASC');
		$query = $this->db->get('sub_category s,product p');
		return $query->result_array();
	}

	public function exist_url($url, $id = null)
	{
		$this->db->where('Trim(LOWER(url))', $url);
		if ($id != null) {
			$this->db->where_not_in('category_id', $id);
		}
		$query = $this->db->get('category');
		$rs =  $query->num_rows();
		if ($rs > 0) {
			return false;
		} else {
			return true;
		}
	}

	public function exist_sub_url($url, $id = null)
	{
		$this->db->where('Trim(LOWER(url))', $url);
		if ($id != null) {
			$this->db->where_not_in('sub_category_id', $id);
		}
		$query = $this->db->get('sub_category');
		$rs =  $query->num_rows();
		if ($rs > 0) {
			return false;
		} else {
			return true;
		}
	}
}
