<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class OrderReportModel extends CI_Model{

	public function dailyOrderReport($date,$company_id){
		$new_date=date("Y-m-d",strtotime(str_replace('/','-',$date)));
		$this->db->select("*");
		$this->db->where('flag = 1');
		$this->db->where('status','delivered');
		$this->db->where('company_id',$company_id);
		$this->db->where("DATE_FORMAT(created_date,'%Y-%m-%d')", $new_date);
		$this->db->from('hcs_order_master');

		$query=$this->db->get();
		if($query->num_rows() >0){
			$result=$query->result_array();
			return $result;
		}
		else{
			return false;
		}

	}

	public function dateRangeOrderReport($start_date,$end_date,$company_id){
		
		$new_start_date=date("Y-m-d",strtotime(str_replace('/','-',$start_date)));
		$new_end_date=date("Y-m-d",strtotime(str_replace('/','-',$end_date)));
		
		$this->db->select("*");
		$this->db->where('flag = 1');
		$this->db->where('status','delivered');
		$this->db->where('company_id',$company_id);
		$this->db->where("DATE_FORMAT(created_date,'%Y-%m-%d') >= ", $new_start_date);
		$this->db->where("DATE_FORMAT(created_date,'%Y-%m-%d') <= ", $new_end_date);
		$this->db->from('hcs_order_master');


		$query=$this->db->get();
		if($query->num_rows() >0){
			$result=$query->result_array();
			return $result;
		}
		else{
			return false;
		}
	}


	public function monthlyOrderReport($month,$year,$company_id){

		$this->db->select("*");
		$this->db->where('flag = 1');
		$this->db->where('status','delivered');
		$this->db->where('company_id',$company_id);
		$this->db->where("month(created_date)", $month);
		$this->db->where("year(created_date)", $year);
		$this->db->from('hcs_order_master');

		$query=$this->db->get();
		if($query->num_rows() >0){
			$result=$query->result_array();
			return $result;
		}
		else{
			return false;
		}
	}

	public function yearlyOrderReport($year,$company_id){
		$this->db->select("*");
		$this->db->where('flag = 1');
		$this->db->where('status','delivered');
		$this->db->where('company_id',$company_id);
		$this->db->where("year(created_date)", $year);
		$this->db->from('hcs_order_master');

		$query=$this->db->get();
		if($query->num_rows() >0){
			$result=$query->result_array();
			return $result;
		}
		else{
			return false;
		}
	}

	public function getSingleOrderDetailsData($order_id){
		$this->db->select("a.*,b.product_name");
		$this->db->where('a.order_id',$order_id);
		$this->db->join('hcs_products as b', 'a.product_id = b.product_id');
		$this->db->from('hcs_order_details as a');

		$query=$this->db->get();
		if($query->num_rows() >0){
			$result=$query->result_array();
			return $result;
		}
		else{
			return false;
		}
	}

}