<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PatientReportModel extends CI_Model{



	public function getSinglePatientData($patient_id,$company_id){
		$result=$this->getIDProcessing($patient_id);
		$employee_id=$result->employee_id;

		$this->db->select("CONCAT(a.firstname,' ',a.lastname) as name ,a.patient_tracking_no,a.`firstname`, a.`lastname`, a.`gender`, a.`date_of_birth`, a.`address`, a.`contact_no`, a.email, COUNT(b.test_id) as total_test");
		$this->db->join('hcs_test as b', 'a.employee_id = b.employee_id');
		$this->db->where("a.employee_id", $employee_id); 
		$this->db->where('a.company_id = b.company_id');
		$this->db->where('a.company_id',$company_id);
		$this->db->from('hcs_employee as a');
		$query=$this->db->get();
		return $query->row();
	}


	public function getSinglePatientTestData($patient_id){
		$result=$this->getIDProcessing($patient_id);
		$employee_id=$result->employee_id;

		$this->db->select("`test_type`, `test_date`, `created_at`, `result`, `specimen`, `confirmed_case`, `retest`, `retest_date`, `self_isolation_recomanded`, `rt_pcr`");
		$this->db->where('employee_id',$employee_id);
		$query = $this->db->get('hcs_test');
		return $query->result_array();
	}


	public function getAllPatientData($company_id){
		$this->db->select("sha1(a.employee_id) as patient_id,CONCAT(a.firstname,' ',a.lastname) as name ,a.patient_tracking_no,a.`firstname`, a.`lastname`, a.`gender`, a.`date_of_birth`, a.`address`, a.`contact_no`, a.email, COUNT(b.test_id) as total_test");
		$this->db->join('hcs_test as b', 'a.employee_id = b.employee_id');
		$this->db->where('a.company_id',$company_id);
		$this->db->from('hcs_employee as a');
		$this->db->group_by("a.employee_id"); 
		$query=$this->db->get();

		if($query->num_rows() >0){
			$result=$query->result_array();
			return $result;
		}
		else{
			return false;
		}
	}

	public function getIDProcessing($id) {
		$this->db->select("employee_id");
		$this->db->where('sha1(employee_id)',$id);
		$query = $this->db->get('hcs_employee');
		return $query->row();
	}
}