<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class TestReportModel extends CI_Model{



	public function dailyTestReport($date,$company_id,$result){
		$this->db->select("a.`test_id`, a.`test_date`,a.`employee_id`, a.`test_type`, a.`result`, a.`specimen`, a.`confirmed_case`, a.`self_isolation_recomanded`, a.`rt_pcr`,a.`retest`, a.`client_id`,CONCAT(b.firstname,' ',b.lastname) as name ,b.firstname, b.patient_tracking_no,b.lastname, b.`gender`, b.`date_of_birth`, b.`address`, b.`contact_no`, b.`email`,a.retest_date");
	    $this->db->join('hcs_employee as b', 'a.employee_id = b.employee_id');
	    $this->db->where('a.company_id = b.company_id');
	    $this->db->where('a.company_id',$company_id);
	    if($result!='All'){
	    	 $this->db->where("a.result",$result);
	    }
	    $this->db->where("a.test_date",$date);
	    $this->db->from('hcs_test as a');

	    $query=$this->db->get();
		if($query->num_rows() >0){
			$result=$query->result_array();
			return $result;
		}
		else{
			return false;
		}

	}

	public function dateRangeTestReport($start_date,$end_date,$company_id,$result){
		
		$new_start_date=date("Y-m-d",strtotime(str_replace('/','-',$start_date)));
		$new_end_date=date("Y-m-d",strtotime(str_replace('/','-',$end_date)));

		$this->db->select("a.`test_id`, a.`employee_id`, a.`test_type`,a.test_date, STR_TO_DATE(a.`test_date`,'%d/%m/%Y') as test_date_new,a.`result`, a.`specimen`, a.`confirmed_case`, a.`self_isolation_recomanded`, a.`rt_pcr`,a.`retest`, a.`client_id`,CONCAT(b.firstname,' ',b.lastname) as name ,b.firstname, b.lastname, b.`gender`,b.patient_tracking_no, b.`date_of_birth`, b.`address`, b.`contact_no`, b.`email`,a.retest_date");
	    $this->db->join('hcs_employee as b', 'a.employee_id = b.employee_id');
	    $this->db->where("DATE_FORMAT(STR_TO_DATE(a.`test_date`,'%d/%m/%Y'),'%Y-%m-%d') >= ", $new_start_date);
	    $this->db->where("DATE_FORMAT(STR_TO_DATE(a.`test_date`,'%d/%m/%Y'),'%Y-%m-%d') <= ", $new_end_date);
	    $this->db->where('a.company_id = b.company_id');
	    $this->db->where('a.company_id',$company_id);
	    if($result!='All'){
	    	 $this->db->where("a.result",$result);
	    }
	    $this->db->order_by("test_date_new", "ASC");
	    $this->db->from('hcs_test as a');

	    $query=$this->db->get();
		if($query->num_rows() >0){
			$result=$query->result_array();
			return $result;
		}
		else{
			return false;
		}
	}


	public function monthlyTestReport($month,$year,$company_id,$result){
		$this->db->select("a.`test_id`, a.`employee_id`, a.`test_type`,a.test_date, STR_TO_DATE(a.`test_date`,'%d/%m/%Y') as test_date_new,a.`result`, a.`specimen`, a.`confirmed_case`, a.`self_isolation_recomanded`, a.`rt_pcr`,a.`retest`, a.`client_id`,CONCAT(b.firstname,' ',b.lastname) as name ,b.firstname, b.lastname, b.`gender`,b.patient_tracking_no, b.`date_of_birth`, b.`address`, b.`contact_no`, b.`email`,a.retest_date");
	    $this->db->join('hcs_employee as b', 'a.employee_id = b.employee_id');
	    $this->db->where("month(STR_TO_DATE(a.`test_date`,'%d/%m/%Y'))", $month);
	    $this->db->where("year(STR_TO_DATE(a.`test_date`,'%d/%m/%Y'))", $year);
	    $this->db->where('a.company_id = b.company_id');
	    $this->db->where('a.company_id',$company_id);
	    if($result!='All'){
	    	 $this->db->where("a.result",$result);
	    }
	    $this->db->order_by("test_date_new", "ASC");
	    $this->db->from('hcs_test as a');

	    $query=$this->db->get();
		if($query->num_rows() >0){
			$result=$query->result_array();
			return $result;
		}
		else{
			return false;
		}
	}

	public function yearlyTestReport($year,$company_id,$result){
		$this->db->select("a.`test_id`, a.`employee_id`, a.`test_type`,a.test_date, STR_TO_DATE(a.`test_date`,'%d/%m/%Y') as test_date_new,a.`result`, a.`specimen`, a.`confirmed_case`, a.`self_isolation_recomanded`, a.`rt_pcr`,a.`retest`, a.`client_id`,CONCAT(b.firstname,' ',b.lastname) as name ,b.firstname, b.lastname, b.patient_tracking_no,b.`gender`, b.`date_of_birth`, b.`address`, b.`contact_no`, b.`email`,a.retest_date");
	    $this->db->join('hcs_employee as b', 'a.employee_id = b.employee_id');
	    $this->db->where("year(STR_TO_DATE(a.`test_date`,'%d/%m/%Y'))", $year);
	    $this->db->where('a.company_id = b.company_id');
	    $this->db->where('a.company_id',$company_id);
	    if($result!='All'){
	    	 $this->db->where("a.result",$result);
	    }
	    $this->db->order_by("test_date_new", "ASC");
	    $this->db->from('hcs_test as a');

	    $query=$this->db->get();
		if($query->num_rows() >0){
			$result=$query->result_array();
			return $result;
		}
		else{
			return false;
		}
	}

}