<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<meta name="base_url" content="<?=base_url()?>">
	<?php
		$uri_string=uri_string();
		$uri=explode('/',$uri_string);
		if(sizeof($uri)==3 && $uri[0]=='product') {
			$product_url = base_url() . "product/" . $product->sub_url."/".$product->url;
			?>
	<meta name="keywords" content="<?php echo $product->tag ?>">
	<meta name="description" content="<?php echo $product->meta_description ?>">
	<meta name="title" content="<?php echo $product->product_name ?>">
	<meta name="url" content="<?php echo $product_url ?>">
	<?php
		}
	?>
	<title><?=$title?></title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php $this->load->view('includes/head'); ?>

</head>

<body>
<!--[if lte IE 9]>
<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
<![endif]-->

<!-- header-start -->
<header>
	<?php $this->load->view('includes/navigation'); ?>
</header>
<!-- header-end -->

<div class="main_content">
	<?php $this->load->view($content); ?>
</div>


<?php $this->load->view('includes/footer'); ?>
<!-- link that opens popup -->

<div class="modal" id="login_view">
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body">
				<div class="col-12">
					<div class="  pr-lg-50">
						<h2>Sign In</h2>
						<div class="page-alerts">
							<div class="alert alert-danger page-alert" id="alert-1">
								<button type="button" class="close"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
								<span id="notification"></span>
							</div>
						</div>
						<form id="sigin_form" class="bg-white contact-form">
							<div class="form-group">
								<input type="email" name="email" class="form-control" placeholder="Enter your Email" required>
							</div>
							<div class="form-group">
								<input type="password" name="password" class="form-control" placeholder="Enter your Password" required>
							</div>
							<?php
							$csrf = array(
									'name' => $this->security->get_csrf_token_name(),
									'hash' => $this->security->get_csrf_hash()
							);
							?>
							<input type="hidden" name="<?= $csrf['name']; ?>" id="token_key" value="<?= $csrf['hash']; ?>" class="form-control login_style" readonly>

							<div class="form-group">
								<input type="submit" value="Login" class="btn btn-primary signin_button px-5">
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php $this->load->view('includes/script'); ?>
<!-- Load Facebook SDK for JavaScript -->
<div id="fb-root"></div>
<script>
	window.fbAsyncInit = function() {
		FB.init({
			xfbml            : true,
			version          : 'v10.0'
		});
	};

	(function(d, s, id) {
		var js, fjs = d.getElementsByTagName(s)[0];
		if (d.getElementById(id)) return;
		js = d.createElement(s); js.id = id;
		js.src = 'https://connect.facebook.net/en_US/sdk/xfbml.customerchat.js';
		fjs.parentNode.insertBefore(js, fjs);
	}(document, 'script', 'facebook-jssdk'));</script>

<!-- Your Chat Plugin code -->
<div class="fb-customerchat"
	 attribution="setup_tool"
	 page_id="679445715790361">
</div>
<script>
	var baseURL=$('meta[name="base_url"]').attr('content');
	$('.page-alert').hide();

	$('.page-alert .close').click(function(e) {
		e.preventDefault();
		$(this).closest('.page-alert').slideUp();
	});

	function notification(text) {

		$('#notification').html('<strong>' + text + '</strong>').slideDown().delay(2000).slideDown();

	}

	$("#sigin_form").validate({

		rules: {
			email: {
				required: true,
				email: true
			},
			password: {
				required: true,
				minlength: 5,
				maxlength: 20
			}
		},

		messages: {
			email: {
				required: 'Please enter your email address',
				email: 'Please enter a Valid email address'
			},
			password: {
				required: 'Please enter your password'
			}
		},

		submitHandler: function(form) {

			$('.signin_button').css('cursor', 'wait');
			$('.signin_button').attr('disabled', true);

			$.ajax({
				url: baseURL + "loginAuthentication",
				type: 'POST',
				data: $('#sigin_form').serialize(),
				dataType: 'json',
				success: function(res) {


					$("html, body").scrollTop(0);
					$(".page-alerts").css('display', 'block');
					$('.page-alert').slideDown();

					var response_brought = res.response.indexOf('login_successfully=yes');


					if (response_brought != -1) {
						notification('Please wait...');
						window.location.replace(res.response);
					} else {
						$('#password').val('');
						notification('Email and password is incorrect');
					}

					$('.signin_button').css('cursor', 'pointer');
					$('.signin_button').removeAttr('disabled');

				}
			});
		}, // Do not change code below
		errorPlacement: function(error, element) {
			error.insertAfter(element.parent());
		}

	});
</script>
</body>

</html>
