
var baseURL=$('meta[name="base_url"]').attr('content');


$.getJSON(baseURL+"getDonutChartData",function(data){
    $('.negative-head').text(data[1].result);
    $('.negative-value').text(data[1].total);
    $('.positive-head').text(data[2].result);
    $('.positive-value').text(data[2].total);
    $('.invalid-head').text(data[0].result);
    $('.invalid-value').text(data[0].total);
    $('.total-value').text(parseInt(data[0].total)+parseInt(data[1].total)+parseInt(data[2].total));
    Morris.Donut({
        element: 'morris-donut-chart',
        data: [
        {
            label: data[0].result,
            value: data[0].total,

        }, 
        {
            label: data[1].result,
            value: data[1].total,
        }, 
        {
            label: data[2].result,
            value: data[2].total
        }],
        resize: true,
        colors:['#f9a203', '#ee534f', '#2dca0d']
    });
});



$(function () {
    "use strict";
    // ============================================================== 
    // Sales overview
    // ============================================================== 
    
    $.getJSON(baseURL+"getDashboardBarChartData",function(data){
        var positiveData=data.positive;
        var negativeData=data.negative;
        var invalidData=data.invalid;

        

        var new_positive_array=positiveData.split(',').map(Number);
        var new_negative_array=negativeData.split(',').map(Number);
        var new_invalid_array=invalidData.split(',').map(Number);

        var max=data.maxVAl*1.3;
        

        var chart = new Chartist.Bar('.amp-pxl', {
          labels: ['January', 'February', 'March', 'April', 'May', 'June','July', 'August', 'September', 'October', 'November', 'December'],
          series: [
/*            [9000, 5000, 3000, 7000, 5000, 10000,9000, 5000, 3000, 7000, 5000, 10000],
            [6000, 3000, 9000, 5000, 4000, 6000,6000, 3000, 9000, 5000, 4000, 6000],
            [9000, 5000, 3000, 7000, 5000, 10000,9000, 5000, 3000, 7000, 5000, 10000],*/

            [...new_positive_array],
            [...new_negative_array],
            [...new_invalid_array],
            ]
        }, 
        {
          axisX: {
            // On the x-axis start means top and end means bottom
            position: 'end',
            showGrid: false
        },
        axisY: {
            // On the y-axis start means left and end means right
            position: 'start'
            , labelInterpolationFnc: function (value) {
                return (value / 1) + '';
            }
        },
        high: max,
        low: '0',
        plugins: [
        Chartist.plugins.tooltip()
        ]
    });


        // Offset x1 a tiny amount so that the straight stroke gets a bounding box
        // Straight lines don't get a bounding box 
        // Last remark on -> http://www.w3.org/TR/SVG11/coords.html#ObjectBoundingBox
        chart.on('draw', function(ctx) {  
          if(ctx.type === 'area') {    
            ctx.element.attr({
              x1: ctx.x1 + 0.001
          });
        }
    });

        // Create the gradient definition on created event (always after chart re-render)
        chart.on('created', function(ctx) {
          var defs = ctx.svg.elem('defs');
          defs.elem('linearGradient', {
            id: 'gradient',
            x1: 0,
            y1: 1,
            x2: 0,
            y2: 0
        }).elem('stop', {
            offset: 0,
            'stop-color': 'rgba(255, 255, 255, 1)'
        }).parent().elem('stop', {
            offset: 1,
            'stop-color': 'rgba(38, 198, 218, 1)'
        });
    });


        var chart = [chart];

    // ============================================================== 
    // This is for the animation
    // ==============================================================
    
    for (var i = 0; i < chart.length; i++) {
        chart[i].on('draw', function(data) {
            if (data.type === 'line' || data.type === 'area') {
                data.element.animate({
                    d: {
                        begin: 500 * data.index,
                        dur: 500,
                        from: data.path.clone().scale(1, 0).translate(0, data.chartRect.height()).stringify(),
                        to: data.path.clone().stringify(),
                        easing: Chartist.Svg.Easing.easeInOutElastic
                    }
                });
            }
            if (data.type === 'bar') {
                data.element.animate({
                    y2: {
                        dur: 500,
                        from: data.y1,
                        to: data.y2,
                        easing: Chartist.Svg.Easing.easeInOutElastic
                    },
                    opacity: {
                        dur: 500,
                        from: 0,
                        to: 1,
                        easing: Chartist.Svg.Easing.easeInOutElastic
                    }
                });
            }
        });
    }








    //analytic



    var chart = new Chartist.Line('.campaign', {
          labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun','Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
          series: [
            [...new_positive_array],
            [...new_negative_array],
          ]}, 

          {
          low: 0,
          high: max,
          showArea: true,
          fullWidth: true,
          plugins: [
            Chartist.plugins.tooltip()
          ],
            axisY: {
            onlyInteger: true
            , scaleMinSpace: 40    
            , offset: 20
            , labelInterpolationFnc: function (value) {
                return (value / 1) + '';
            }
        },
        });

        // Offset x1 a tiny amount so that the straight stroke gets a bounding box
        // Straight lines don't get a bounding box 
        // Last remark on -> http://www.w3.org/TR/SVG11/coords.html#ObjectBoundingBox
        chart.on('draw', function(ctx) {  
          if(ctx.type === 'area') {    
            ctx.element.attr({
              x1: ctx.x1 + 0.001
            });
          }
        });

        // Create the gradient definition on created event (always after chart re-render)
        chart.on('created', function(ctx) {
          var defs = ctx.svg.elem('defs');
          defs.elem('linearGradient', {
            id: 'gradient',
            x1: 0,
            y1: 1,
            x2: 0,
            y2: 0
          }).elem('stop', {
            offset: 0,
            'stop-color': 'rgba(255, 255, 255, 1)'
          }).parent().elem('stop', {
            offset: 1,
            'stop-color': 'rgba(38, 198, 218, 1)'
          });
        });
    
            
    var chart = [chart];

    // ============================================================== 
    // This is for the animation
    // ==============================================================
    
    for (var i = 0; i < chart.length; i++) {
        chart[i].on('draw', function(data) {
            if (data.type === 'line' || data.type === 'area') {
                data.element.animate({
                    d: {
                        begin: 500 * data.index,
                        dur: 500,
                        from: data.path.clone().scale(1, 0).translate(0, data.chartRect.height()).stringify(),
                        to: data.path.clone().stringify(),
                        easing: Chartist.Svg.Easing.easeInOutElastic
                    }
                });
            }
            if (data.type === 'bar') {
                data.element.animate({
                    y2: {
                        dur: 500,
                        from: data.y1,
                        to: data.y2,
                        easing: Chartist.Svg.Easing.easeInOutElastic
                    },
                    opacity: {
                        dur: 500,
                        from: 0,
                        to: 1,
                        easing: Chartist.Svg.Easing.easeInOutElastic
                    }
                });
            }
        });
    }


});




});        


