var baseURL=$('meta[name="base_url"]').attr('content');
var token_key=$('#token_key').val();

var categoryTable = $('#categoryTable').DataTable( {
	"processing": true,
	"serverSide": true,
	"deferRender": true,
	"ajax":{
		"url": baseURL + "dataHandling/getCategoryData",
		"type": "POST",
		data: function(d) {
			d.csrf_medisave_secured = token_key;
		}
	},

	"columns": [
		null,
		{ "className": ""},
		{ "className": ""},
		{ "className": ""},
		{ "className": "center",searchable: false,orderable: false },
	],
	"autoWidth": false,


	"columnDefs": [ {
		"targets": -1,
		"data": null,
		"defaultContent": "<td align='center'><a href='#view_update_data' role='button' id='details' class='btn btn-primary btn-xs small_btn' title='Details' data-toggle='modal'><i class='fa fa-bars'></i> View</a> <a href='javascript:void(0)' role='button' id='delete' class='btn btn-danger btn-xs small_btn' title='Delete'><i class='fa fa-times'></i> Delete</a> </td> "
	} ],

	"aLengthMenu": [
		[10, 25, 50, -1],
		[10, 25, 50, "All"]
	],
	// set the initial value
	"iDisplayLength": 10,
	"bFilter" : true,
	"bLengthChange": true,
	"bInfo": true,
	"bPaginate": true,
	"aaSorting": [[ 0, "asc" ]],

} );

$('#categoryTable tbody').on( 'click', '#details', function () {
	var data = categoryTable.row( $(this).parents('tr') ).data();
	$('#modal_category_name').val(data[1]);
	$('#modal_serial').val(data[2]);
	$('#modal_status').val(data[3]);
	$('#modal_category_id').val(data[4]);
} );

$('#categoryTable tbody').on('click', '#delete', function () {
	var data = categoryTable.row($(this).parents('tr')).data();
	swal(
		{
			title: "Are you sure?",
			type: "warning",
			showCancelButton: true,
			confirmButtonColor: "#DD6B55",
			confirmButtonText: "Yes, delete it!",
			closeOnConfirm: false,
		},
		function () {
			$.ajax({
				type: "POST",
				url: baseURL + "deleteCategory",
				data: {
					category_id: data[4],
					csrf_medisave_secured: token_key,
				},
				dataType: "json",
				success: function (res) {
					swal({
						title: res.response,
						type: res.type,
						timer: 1500,
						showConfirmButton: false,
						customClass: "swal-height",
					});
					categoryTable.ajax.reload();
				},
			});
		}
	);
});

$("#addForm").validate({

	rules:
		{
			category_name:
				{
					required: true,
				},
			serial:
				{
					required: true,
					number: true,
				},
		},

	messages:
		{
			category_name:
				{
					required: "Please type category name",
				},
			serial:
				{
					required: "Type a serial number",
					number: "Write in number format",
				},
		},

	submitHandler: function(form) {

		$('.submit_button').css('cursor', 'wait');
		$('.submit_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "newCategoryEntryProcess",
			type: 'POST',
			data: $('#addForm').serialize(),
			dataType:'json',
			success: function(res) {
				swal({
					title: res.response,
					type: res.type,
					timer: 1500,
					showConfirmButton: false,
					customClass: 'swal-height'
				});

				if (res.type=='success')
				{
					$('.open').trigger('click');
					$("#addForm").trigger("reset");
					categoryTable.ajax.reload();
				}


				$('.submit_button').css('cursor', 'pointer');
				$('.submit_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function(error, element)
	{
		error.insertAfter(element.parent());
	}

});

$("#updateForm").validate({

	rules:
		{
			category_name:
				{
					required: true,
				},
			serial:
				{
					required: true,
					number: true,
				},
			status:
				{
					required: true,
				},
		},

	messages:
		{
			category_name:
				{
					required: "Please type category name",
				},
			serial:
				{
					required: "Type a serial number",
					number: "Write in number format",
				},
			status:
				{
					required: "Please select a status",
				},
		},

	submitHandler: function(form) {

		$('.update_button').css('cursor', 'wait');
		$('.update_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "categoryEditProcess",
			type: 'POST',
			data: $('#updateForm').serialize(),
			dataType:'json',
			success: function(res) {
				swal({
					title: res.response,
					type: res.type,
					timer: 1500,
					showConfirmButton: false,
					customClass: 'swal-height'
				});

				if (res.type=='success')
				{
					$("#updateForm").trigger("reset");
					$('#view_update_data').modal('hide');
					categoryTable.ajax.reload();
				}

				$('.update_button').css('cursor', 'pointer');
				$('.update_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function(error, element)
	{
		error.insertAfter(element.parent());
	}

});
