
var baseURL=$('meta[name="base_url"]').attr('content');
var token_key = $('#token_key').val();


var contactTable = $('#contactTable').DataTable({
	"processing": true,
	"serverSide": true,
	"deferRender": true,
	"ajax": {
		"url": baseURL + "dataHandling/getContactData",
		"type": "POST",
		data: function (d) {
			d.csrf_medisave_secured = token_key;
		}
	},

	"columns": [
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "center", searchable: false, orderable: false },
	],
	"autoWidth": false,


	"columnDefs": [{
		"targets": -1,
		"data": null,
		"defaultContent": "<td align='center'><a href='#view_update_data' role='button' id='details' class='btn btn-primary btn-xs small_btn' title='Details' data-toggle='modal'><i class='fa fa-bars'></i> View</a> </td> "
	},
	{
		targets: 4,
		render: function (data, type, row, meta) {
			var color = 'black';
			if (data == 'Unseen') {
				color = 'red';
				var rowIndex = meta.row + 1;
				$('#contactTable tbody tr:nth-child(' + rowIndex + ')').addClass('green');
			}
			if (data == 'Seen') {
				color = 'green';
			}
			return '<span style="color:' + color + '">' + data + '</span>';
		}
	}
	],

	"aLengthMenu": [
		[10, 25, 50, -1],
		[10, 25, 50, "All"]
	],
	// set the initial value
	"iDisplayLength": 10,
	"bFilter": true,
	"bLengthChange": true,
	"bInfo": true,
	"bPaginate": true,
	"aaSorting": [[0, "asc"]],

});


$('#contactTable tbody').on('click', '#details', function () {
	var data = contactTable.row($(this).parents('tr')).data();
	setModalData(data);
	$.ajax({
		type: "post",
		url: baseURL + "updateMessageStatus",
		data: {
			id: data[7],
			csrf_medisave_secured: token_key
		},
		dataType: "json",
		success: function (res) {
			var response_brought = res.response.indexOf('Status updated');
			if (response_brought != -1) {
				contactTable.ajax.reload();
			}
		}
	});
});

function setModalData(data) {
	$('#modal_sender_name').val(data[2]);
	$('#modal_sender_email').val(data[3]);
	$('#modal_sender_phone').val(data[5]);
	$('#modal_message_subject').val(data[1]);
	$('#modal_message_body').val(data[6]);
}

$("#addForm").validate({

	rules:
	{
		category_name:
		{
			required: true,
		},
	},

	messages:
	{
		category_name:
		{
			required: "Please type unit name",
		},
	},

	submitHandler: function (form) {

		$('.submit_button').css('cursor', 'wait');
		$('.submit_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "newCategoryEntryProcess",
			type: 'POST',
			data: $('#addForm').serialize(),
			dataType: 'json',
			success: function (res) {
				$('.open').trigger('click');

				var response_brought = res.response.indexOf('Category Added successfully');


				if (response_brought != -1) {
					swal({
						title: "Category Added Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#addForm").trigger("reset");
					unitTable.ajax.reload();
				}
				$('.submit_button').css('cursor', 'pointer');
				$('.submit_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function (error, element) {
		error.insertAfter(element.parent());
	}

});

$("#updateForm").validate({

	rules:
	{
		category_name:
		{
			required: true,
		},
		status:
		{
			required: true,
		},
	},

	messages:
	{
		category_name:
		{
			required: "Please type category name",
		},
		status:
		{
			required: "Please select a status",
		},
	},

	submitHandler: function (form) {

		$('.update_button').css('cursor', 'wait');
		$('.update_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "categoryEditProcess",
			type: 'POST',
			data: $('#updateForm').serialize(),
			dataType: 'json',
			success: function (res) {
				var response_brought = res.response.indexOf('Category update successfully');
				if (response_brought != -1) {
					swal({
						title: "Category Update Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#updateForm").trigger("reset");
					$('#view_update_data').modal('hide');
					categoryTable.ajax.reload();
				}



				$('.update_button').css('cursor', 'pointer');
				$('.update_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function (error, element) {
		error.insertAfter(element.parent());
	}

});
