var baseURL=$('meta[name="base_url"]').attr('content');
var token_key = $('#token_key').val();

var galleryTable = $('#galleryTable').DataTable({
	"processing": true,
	"serverSide": true,
	"deferRender": true,
	"ajax": {
		"url": baseURL + "dataHandling/getGalleryData",
		"type": "POST",
		data: function (d) {
			d.csrf_medisave_secured = token_key;
		}
	},

	"columns": [
		null,
		{ "className": "" },
		{ "className": "center", searchable: false, orderable: false },
	],
	"autoWidth": false,


	"columnDefs": [{
		"targets": -1,
		"data": null,
		"defaultContent": "<td align='center'><a href='javascript:void(0)' role='button' id='delete' class='btn btn-danger btn-xs small_btn' title='Delete'><i class='fa fa-times'></i> Delete</a> </td></td> "
	},
		{
			targets: 1,
			render: function (data, type, row) {
				return '<img src="'+baseURL+'assets/img/gallery/'+data+'" style="width: 200px">';
			}
		}
	],

	"aLengthMenu": [
		[10, 25, 50, -1],
		[10, 25, 50, "All"]
	],
	// set the initial value
	"iDisplayLength": 10,
	"bFilter": true,
	"bLengthChange": true,
	"bInfo": true,
	"bPaginate": true,
	"aaSorting": [[0, "asc"]],

});

$uploadCrop = $('#upload-demo').croppie({
	enableExif: true,
	viewport: {
		width: 500,
		height: 300,
		type: 'rectangle'
	},
	boundary: {
		width: 510,
		height: 310,
	}
});

$('#upload').on('change', function () {
	var reader = new FileReader();
	reader.onload = function (e) {
		$uploadCrop.croppie('bind', {
			url: e.target.result
		}).then(function () {
			console.log('jQuery bind complete');
		});
	}
	reader.readAsDataURL(this.files[0]);
});

function resetImg(){
	$('.upload-demo').removeClass('ready');
	$("#upload-demo").html("");
	$uploadCrop=null;

	$uploadCrop = $('#upload-demo').croppie({
		enableExif: true,
		viewport: {
			width: 500,
			height: 300,
			type: 'rectangle'
		},
		boundary: {
			width: 510,
			height: 310,
		}
	});
}

$('.upload-result').on('click', function (ev) {

	$('.upload-result').css('cursor', 'wait');
	$('.upload-result').attr('disabled');

	$uploadCrop.croppie('result', {
		type: 'canvas',
		size: 'viewport'
	}).then(function (resp) {
		$.ajax({
			url: baseURL + "dataHandling/addGalleryPicture",
			type: "POST",
			data: { "image": resp, "csrf_medisave_secured": token_key },
			dataType: 'json',
			success: function (data) {
				var response_brought = data.response.indexOf('Picture Added successfully');
				if (response_brought != -1) {
					swal({
						title: "Picture Added Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});
					galleryTable.ajax.reload();
					$('.open').trigger('click');
				}

				$('.upload-result').css('cursor', 'pointer');
				$('.upload-result').removeAttr('disabled');
			}
		});
	});
});

$('#galleryTable tbody').on('click', '#delete', function () {
	var data = galleryTable.row($(this).parents('tr')).data();
	swal(
		{
			title: "Are you sure?",
			type: "warning",
			showCancelButton: true,
			confirmButtonColor: "#DD6B55",
			confirmButtonText: "Yes, delete it!",
			closeOnConfirm: false,
		},
		function () {
			$.ajax({
				type: "POST",
				url: baseURL + "deleteGallery",
				data: {
					gallery_id: data[2],
					gallery_picture: data[1],
					csrf_medisave_secured: token_key,
				},
				dataType: "json",
				success: function (res) {
					var response_brought = res.response.indexOf("deleted_successfully");
					if (response_brought != -1) {
						swal({
							title: "Deleted!",
							type: "success",
							timer: 1500,
							showConfirmButton: false,
							customClass: "swal-height",
						});
					}
					galleryTable.ajax.reload();
				},
			});
		}
	);
});
