
var baseURL=$('meta[name="base_url"]').attr('content');






var tiles = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
	maxZoom: 25,
	attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors Arifen Aziz, Abdullah Al Quiyum &copy 2020'
}),
latlng = L.latLng(53.2829, -3.8295);

var map = L.map('map', {center: latlng, zoom: 6, layers: [tiles]});



var markers = L.markerClusterGroup({
	chunkedLoading: true,
	singleMarkerMode: false,
	spiderfyOnMaxZoom: true
});




var customOptions =
{
	'maxWidth': '500',
	'className' : 'custom'
}

var myIcon;
var greenIcon = L.icon({
	iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-green.png',
	shadowUrl: 'https://cdnjs.cloudflare.com/ajax/libs/leaflet/0.7.7/images/marker-shadow.png',
	iconSize: [25, 40],
	iconAnchor: [12, 41],
	popupAnchor: [1, -34],
	shadowSize: [41, 41]    
});	

var redIcon = L.icon({
	iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-red.png',
	shadowUrl: 'https://cdnjs.cloudflare.com/ajax/libs/leaflet/0.7.7/images/marker-shadow.png',
	iconSize: [25, 40],
	iconAnchor: [12, 41],
	popupAnchor: [1, -34],
	shadowSize: [41, 41]    
});


function resultDetect(result){
	if(result=='Positive'){
		myIcon=redIcon;
	}
	else{
		myIcon=greenIcon;
	}
	return myIcon;
}

$.getJSON(baseURL+"getMapData",function(data){

	for (var i = 0; i < data.length; i++) {
		var a = data[i];
		var title = a.name;
		var testInfo = a.result;
		var image=baseURL+'assets/images/patients/patient-36.png';

		var iconDetect=resultDetect(testInfo);	

		var marker = L.marker(new L.LatLng(a.lat, a.log));
		marker.bindPopup("<img src='"+image+"' class='map-image'/><p>Name: <strong>" +title+"</strong></p><p>Result : <strong>"+testInfo+"</strong></p><p>Company: <strong>"+a.company_name+"</strong></p>");
		

		//popup on hover
		marker.on('mouseover', function (e) {
			this.openPopup();
		});
		/*marker.on('mouseout', function (e) {
			this.closePopup();
		});*/


		marker.setIcon(iconDetect);
		markers.addLayer(marker);
	}
});




map.addLayer(markers);
