var baseURL=$('meta[name="base_url"]').attr('content');
var token_key = $('#token_key').val();

$("#addForm").validate({

	rules:
		{
			notice:
				{
					required: true,
					maxlength: 200
				}
		},

	messages:
		{
			notice:
				{
					required: "Please write a short notice",
					maxlength: "Maximum 200 characters",
				}
		},

	submitHandler: function (form) {

		$('.submit_button').css('cursor', 'wait');
		$('.submit_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "newNoticeEntryProcess",
			type: 'POST',
			data: $('#addForm').serialize(),
			dataType: 'json',
			success: function (res) {
				$('.open').trigger('click');

				var response_brought = res.response.indexOf('Notice save successfully');

				if (response_brought != -1) {
					swal({
						title: "Notice Added Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#addForm").trigger("reset");
					noticeTable.ajax.reload();
				}

				$('.submit_button').css('cursor', 'pointer');
				$('.submit_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function (error, element) {
		error.insertAfter(element.parent());
	}

});



var noticeTable = $('#noticeTable').DataTable({
	"processing": true,
	"serverSide": true,
	"deferRender": true,
	"ajax": {
		"url": baseURL + "dataHandling/getNoticeData",
		"type": "POST",
		data: function (d) {
			d.csrf_medisave_secured = token_key;
		}
	},

	"columns": [
		null,
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "center", searchable: false, orderable: false },
	],
	"autoWidth": false,


	"columnDefs": [{
		"targets": -1,
		"data": null,
		"defaultContent": "<td align='center'><a href='#full_width_modal_parent' role='button' id='details' class='btn btn-primary btn-xs small_btn' title='Details' data-toggle='modal'><i class='fa fa-bars'></i> View</a> </td></td> "
	},
		{
			targets: 3,
			render: function (data, type, row) {
				var color = 'green';
				if (data == 'De-Active') {
					color = 'red';
				}
				if (data == 'Active') {
					color = 'green';
				}
				return '<span style="color:' + color + '">' + data + '</span>';
			}
		}
	],

	"aLengthMenu": [
		[10, 25, 50, -1],
		[10, 25, 50, "All"]
	],
	// set the initial value
	"iDisplayLength": 10,
	"bFilter": true,
	"bLengthChange": true,
	"bInfo": true,
	"bPaginate": true,
	"aaSorting": [[0, "asc"]],

});


$('#noticeTable tbody').on('click', '#details', function () {
	var data = noticeTable.row($(this).parents('tr')).data();
	$('#modal_id').val(data[5]);
	$('#modal_notice').val(data[2]);
	$('#modal_status').val(data[4]);
});


$("#updateForm").validate({
	rules:
		{
			notice:
				{
					required: true,
					maxlength: 200
				},
			status: {
				required: true,
			}
		},

	messages:
		{
			notice:
				{
					required: "Please write a short notice",
					maxlength: "Maximum 200 characters",
				},
			status: {
				required: "Please select a status"
			}
		},
	submitHandler: function (form) {

		$('.update_button_2').css('cursor', 'wait');
		$('.update_button_2').attr('disabled', true);

		$.ajax({
			url: baseURL + "noticeEditProcess",
			type: 'POST',
			data: $('#updateForm').serialize(),
			dataType: 'json',
			success: function (res) {
				var response_brought = res.response.indexOf('Notice update successfully');
				if (response_brought != -1) {
					swal({
						title: "Notice Update Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#updateForm").trigger("reset");
					$('#full_width_modal_parent').modal('hide');
					noticeTable.ajax.reload();
				}

				$('.update_button_2').css('cursor', 'pointer');
				$('.update_button_2').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function (error, element) {
		error.insertAfter(element.parent());
	}

});
