var baseURL=$('meta[name="base_url"]').attr('content');
var token_key = $('#token_key').val();

$(document).on("change", "#check", function () {
	if ($(this).prop("checked") == true) {
		$('#testimony').slideDown();
	}
	else if ($(this).prop("checked") == false) {
		$('#testimony').slideUp();
	}
});

$(document).on("change", "#modal_check", function () {
	if ($(this).prop("checked") == true) {
		$('#modal_testimony').slideDown();
	}
	else if ($(this).prop("checked") == false) {
		$('#modal_testimony').slideUp();
	}
});

$("#addForm").validate({

	rules:
	{
		date:
		{
			required: true,
		},
		portfolio_title:
		{
			required: true,
		},
		company_name:
		{
			required: true,
		},
		company_address:
		{
			required: true,
		},
		content:
		{
			required: true,
		},
		contact_person:
		{
			required: true,
		},
		contact_person_post:
		{
			required: true,
		},
		testimonial:
		{
			required: true,
		}
	},

	messages:
	{
		date:
		{
			required: "Please choose a date",
		},
		portfolio_title:
		{
			required: "Please type portfolio title",
		},
		company_name:
		{
			required: "Please type company name",
		},
		company_address:
		{
			required: "Please type company address",
		},
		content:
		{
			required: "Please write details about this portfolio",
		},
		contact_person:
		{
			required: "Please type reviewer's name",
		},
		contact_person_post:
		{
			required: "Please type reviewer's designation",
		},
		testimonial:
		{
			required: "Please type reviewer's testimony",
		},
	},

	submitHandler: function (form) {

		$('.submit_button').css('cursor', 'wait');
		$('.submit_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "newPortfolioEntryProcess",
			type: 'POST',
			data: $('#addForm').serialize(),
			dataType: 'json',
			success: function (res) {
				$('.open').trigger('click');

				var response_brought = res.response.indexOf('Portfolio Added successfully');

				if (response_brought != -1) {
					swal({
						title: "Portfolio Added Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#addForm").trigger("reset");
					$('#summernote').summernote('reset');
					portfolioTable.ajax.reload();
				}


				$('.submit_button').css('cursor', 'pointer');
				$('.submit_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function (error, element) {
		error.insertAfter(element.parent());
	}

});

var productInquiryTable = $('#inquiryTable').DataTable({
	"processing": true,
	"serverSide": true,
	"deferRender": true,
	"ajax": {
		"url": baseURL + "dataHandling/getProductInquiryData",
		"type": "POST",
		data: function (d) {
			d.csrf_medisave_secured = token_key;
		}
	},

	"columns": [
		null,
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "center", searchable: false, orderable: false },
	],
	"autoWidth": false,


	"columnDefs": [{
		"targets": -1,
		"data": null,
		"defaultContent": "<td align='center'><a href='#modal_parent' role='button' id='details' class='btn btn-primary btn-xs small_btn' title='Details' data-toggle='modal'><i class='fa fa-bars'></i> View</a> </td></td> "
	},
	{
		targets: 5,
		render: function (data, type, row) {
			var color = 'black';
			return '<a href="' + baseURL + 'product/' + row[9] + '/' + row[8] + '" target="_blank">' + data + '</a>';
		}
	},
	{
		targets: 6,
		render: function (data, type, row, meta) {
			var color = 'black';
			if (data == 'Unseen') {
				color = 'red';
				var rowIndex = meta.row + 1;
				$('#inquiryTable tbody tr:nth-child(' + rowIndex + ')').addClass('green');
			}
			if (data == 'Seen') {
				color = 'green';
			}
			return '<span style="color:' + color + '">' + data + '</span>';
		}
	}
	],

	"aLengthMenu": [
		[10, 25, 50, -1],
		[10, 25, 50, "All"]
	],
	// set the initial value
	"iDisplayLength": 10,
	"bFilter": true,
	"bLengthChange": true,
	"bInfo": true,
	"bPaginate": true,
	"aaSorting": [[0, "asc"]],

});

$('#inquiryTable tbody').on('click', '#details', function () {
	var data = productInquiryTable.row($(this).parents('tr')).data();
	setModalData(data);
	$.ajax({
		type: "post",
		url: baseURL + "updateProductInquiryStatus",
		data: {
			id: data[12],
			csrf_medisave_secured: token_key
		},
		dataType: "json",
		success: function (res) {
			console.log(res);
			var response_brought = res.response.indexOf('Status updated');
			if (response_brought != -1) {
				productInquiryTable.ajax.reload();
			}

		}
	});
});

function setModalData(data) {
	$('#qry_sender_name').val(data[2]);
	$('#qry_sender_phone').val(data[3]);
	$('#qry_sender_email').val(data[4]);
	$('#qry_sender_address').val(data[7]);
	$('#qry_product_name').val(data[5]);
	$('#qry_product_quantity').val(data[10]);
	$('#qry_message').val(data[11]);
}
