var baseURL=$('meta[name="base_url"]').attr('content');


var token_key=$('#token_key').val();



$(function() {
  introducer_account();
});




function introducer_account() {

 //var parameter = '&csrf_secure_name=' + token_key;
 $.ajax({
   url: baseURL + "dataHandling/getAccountInfo",
   type: 'GET',
   /* data: parameter,*/
   dataType:'json',
   success: function(response) {
     $("#firstname").val(response.firstname);
     $("#lastname").val(response.lastname);
     $("#company_name").val(response.company_name);
     $("#email").val(response.email);
   }
 })


}




$.validator.addMethod(
  "ukDate",
  function(value, element) {
    return value.match(/^(0?[1-9]|[12][0-9]|3[0-1])[/., -](0?[1-9]|1[0-2])[/., -](19|20)?\d{2}$/);
  },
  "Please enter valid date format"

  );


$.validator.addMethod('custom_required', function (value, element) {
  if (value == "") {
    return false;
  } else {
    $('label.error').hide();
    return true;
  }
}, "");

$.validator.addMethod("lettersonly", function(value, element) {
  return this.optional(element) || /^[a-z\s]+$/i.test(value);
}, "Only alphabetical characters");


$.validator.addMethod( "phoneUK", function( phone_number, element ) {
  phone_number = phone_number.replace( /\(|\)|\s+|-/g, "" );
  return this.optional( element ) || phone_number.length > 9 &&
  phone_number.match( /^(?:(?:(?:00\s?|\+)44\s?)|(?:\(?0))(?:\d{2}\)?\s?\d{4}\s?\d{4}|\d{3}\)?\s?\d{3}\s?\d{3,4}|\d{4}\)?\s?(?:\d{5}|\d{3}\s?\d{3})|\d{5}\)?\s?\d{4,5})$/ );
}, "Please specify a valid phone number" );

$("#introducer_form").validate({



  rules:{

    firstname:{
      required:true,
      maxlength:30,
    },
    lastname:{
      required:true,
      maxlength:30,
    },
    email:
    {
      required: true,
      email: true,
      remote: {
        param: {
          url: baseURL + "checkProfileUniqueEmail",
          data: { csrf_health_introducer_secured: token_key },
          type: "post",
        }
      }
    },

  },
  messages:{

    firstname:{
      required:'Please type firstname'
    },
    lastname: {
      required: 'Please type lastname'
    },
    email:
    {
      required: "Please type email address",
      email: 'Please type a valid email address',
      remote: 'This email is already exist',
    },
  },


  submitHandler: function(form) {


    $('.form_button').css('cursor', 'wait');
    $('.form_button').attr('disabled', true);




    $.ajax({
     url: baseURL + "dataHandling/postAccountInfo",
     type: 'POST',
     data: $('#introducer_form').serialize(),
     dataType:'json',
     success: function(res) {



      var response_brought = res.response.indexOf('update_succcessfully');
      var response = res.response.indexOf('email_change');
      if (response_brought != -1) 
      {

        console.log(alert);


       swal({
        title: "Successfully Update Data",
        type: "success",
        timer: 1500,
        showConfirmButton: false,
        customClass: 'swal-height'

      });

       $('#user_full_name').text($('#firstname').val()+" "+$('#lastname').val());
       

     }
     else  if (response != -1) {
swal({
        title: "Successfully Update Data",
        type: "success",
        timer: 1500,
        showConfirmButton: false,
        customClass: 'swal-height'

      });
       
      window.location.replace('signOutUser');
     }

     else{

      swal({
        title: "Problem Occur",
        type: "error",
        timer: 1500,
        showConfirmButton: false,
        customClass: 'swal-height'

      });

    }


    $('.form_button').css('cursor', 'pointer');
    $('.form_button').removeAttr('disabled');


  }            
});




    },                                                // Do not change code below
    errorPlacement: function(error, element)
    {
      error.insertAfter(element.parent());
    }


  }); 






$("#password_change_form").validate({

  rules:{

    password:{
      required:true,              
      minlength:6,
      maxlength:20,
    },
    confirmPassword:{
      required:true,
      minlength:6,
      maxlength:20,
      equalTo:'#password'          
    },

  },
  messages:{


    password:{
      required:'Please type your password',
    },
    confirmPassword:{
     required: 'Please type your password one more time',
     equalTo: 'Please type the same password as above'
   },


 },


 submitHandler: function(form) {

  $('.form_button').css('cursor', 'wait');
  $('.form_button').attr('disabled', true);


  $.ajax({
    url: baseURL + "dataHandling/postClientAccountPasswordProcessing",
    type: 'POST',
    data: $('#password_change_form').serialize(),
    dataType:'json',
    success: function(res) {



      var response_brought = res.response.indexOf('update_password_succcessfully');
      if (response_brought != -1) 
      {
       $("#password_change_form").trigger("reset");   

       swal({
        title: "Successfully Password Updated",
        type: "success",
        timer: 1500,
        showConfirmButton: false,
        customClass: 'swal-height'

      });

       window.location.replace('signOutUser');
     }

     else{

      swal({
        title: "Problem Occur",
        type: "error",
        timer: 1500,
        showConfirmButton: false,
        customClass: 'swal-height'

      });

    }


    $('.form_button').css('cursor', 'pointer');
    $('.form_button').removeAttr('disabled');



  }            
});
    },                                                // Do not change code below
    errorPlacement: function(error, element)
    {
      error.insertAfter(element.parent());
    }


  });  
