var baseURL=$('meta[name="base_url"]').attr('content');
var token_key = $('#token_key').val();


$("#addForm").validate({
	rules:
		{
			name:
				{
					required: true,
				},
			designation:
				{
					required: true,
				},
			serial:
				{
					required: true,
				},
		},

	messages:
		{
			name:
				{
					required: "Please type full name",
				},
			designation:
				{
					required: "Please type designation",
				},
			serial:
				{
					required: "Please choose an option",
				},
		},

	submitHandler: function (form) {
		$('.submit_button').css('cursor', 'wait');
		$('.submit_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "newTeamEntryProcess",
			type: 'POST',
			data: $('#addForm').serialize(),
			dataType: 'json',
			success: function (res) {
				$('.open').trigger('click');
				var response_brought = res.response.indexOf('Team Added successfully');

				if (response_brought != -1) {
					swal({
						title: "Team Added Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#addForm").trigger("reset");
					teamTable.ajax.reload();
				}



				$('.submit_button').css('cursor', 'pointer');
				$('.submit_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function (error, element) {
		error.insertAfter(element.parent());
	}

});

var teamTable = $('#teamTable').DataTable({
	"processing": true,
	"serverSide": true,
	"deferRender": true,
	"ajax": {
		"url": baseURL + "dataHandling/getTeamData",
		"type": "POST",
		data: function (d) {
			d.csrf_medisave_secured = token_key;
		}
	},

	"columns": [
		null,
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "" },
		{ "className": "center", searchable: false, orderable: false },
	],
	"autoWidth": false,


	"columnDefs": [{
		"targets": -1,
		"data": null,
		"defaultContent": "<td align='center'><a href='#full_width_modal_parent' role='button' id='details' class='btn btn-primary btn-xs small_btn' title='Details' data-toggle='modal'><i class='fa fa-bars'></i> View</a> </td></td> "
	},
		{
			targets: 5,
			render: function (data, type, row) {
				var color = 'black';
				if (data == 'Not Publish') {
					color = 'red';
				}
				if (data == 'Published') {
					color = 'green';
				}
				return '<span style="color:' + color + '">' + data + '</span>';
			}
		}
	],

	"aLengthMenu": [
		[10, 25, 50, -1],
		[10, 25, 50, "All"]
	],
	// set the initial value
	"iDisplayLength": 10,
	"bFilter": true,
	"bLengthChange": true,
	"bInfo": true,
	"bPaginate": true,
	"aaSorting": [[0, "asc"]],

});

$uploadCrop = $('#upload-demo').croppie({
	enableExif: true,
	viewport: {
		width: 400,
		height: 410,
		type: 'rectangle'
	},
	boundary: {
		width: 410,
		height: 420,
	}
});

$('#upload').on('change', function () {
	var reader = new FileReader();
	reader.onload = function (e) {
		$uploadCrop.croppie('bind', {
			url: e.target.result
		}).then(function () {
			console.log('jQuery bind complete');
		});
	}
	reader.readAsDataURL(this.files[0]);
});

$('.upload-result').on('click', function (ev) {

	$('.upload-result').css('cursor', 'wait');
	$('.upload-result').attr('disabled');

	$uploadCrop.croppie('result', {
		type: 'canvas',
		size: 'viewport'
	}).then(function (resp) {
		var team_id = $('#modal_team_id_picture').val();
		$.ajax({
			url: baseURL + "dataHandling/addTeamPicture",
			type: "POST",
			data: { "image": resp, "team_id": team_id, "csrf_medisave_secured": token_key },
			dataType: 'json',
			success: function (data) {
				var response_brought = data.response.indexOf('Picture Added successfully');
				if (response_brought != -1) {
					swal({
						title: "Picture Added Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});
					$("#updateLogo").trigger("reset");
					$('#full_width_modal_parent').modal('hide');
					teamTable.ajax.reload();
				}

				$('.upload-result').css('cursor', 'pointer');
				$('.upload-result').removeAttr('disabled');
			}
		});
	});
});

$('#teamTable tbody').on('click', '#details', function () {
	var data = teamTable.row($(this).parents('tr')).data();
	// console.log(data);
	$('#modal_team_id_picture').val(data[6]);
	$('#modal_team_id').val(data[6]);
	$('#name').val(data[1]);
	$('#designation').val(data[2]);
	$('#serial').val(data[3]);
	$('#modal_status').val(data[4]);
	if (data[7] != null) {
		var imageData = data[7];
	}
	else {
		var imageData = 'image.png';
	}
	var image = "<img src='" + baseURL + "assets/img/team/" + imageData + "' width='120px'/>";
	$('#modal_image').html(image);
});

$("#updateForm").validate({

	rules:
		{
			name:
				{
					required: true,
				},
			designation:
				{
					required: true,
				},
			serial:
				{
					required: true,
				},
		},

	messages:
		{
			name:
				{
					required: "Please type full name",
				},
			designation:
				{
					required: "Please type designation",
				},
			serial:
				{
					required: "Please choose an option",
				},
		},

	submitHandler: function (form) {

		$('.update_button_2').css('cursor', 'wait');
		$('.update_button_2').attr('disabled', true);

		$.ajax({
			url: baseURL + "teamEditProcess",
			type: 'POST',
			data: $('#updateForm').serialize(),
			dataType: 'json',
			success: function (res) {
				var response_brought = res.response.indexOf('Team update successfully');
				if (response_brought != -1) {
					swal({
						title: "Team Update Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#updateForm").trigger("reset");
					$('#full_width_modal_parent').modal('hide');
					teamTable.ajax.reload();
				}

				$('.update_button_2').css('cursor', 'pointer');
				$('.update_button_2').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function (error, element) {
		error.insertAfter(element.parent());
	}

});
