
var baseURL=$('meta[name="base_url"]').attr('content');
var token_key=$('#token_key').val();


var unitTable = $('#unitTable').DataTable( {
	"processing": true,
	"serverSide": true,
	"deferRender": true,
	"ajax":{
		"url": baseURL + "dataHandling/getUnitData",
		"type": "POST",
		data: function(d) {
			d.csrf_medisave_secured = token_key;
		}
	},

	"columns": [
		null,
		{ "className": ""},
		{ "className": ""},
		{ "className": "center",searchable: false,orderable: false },
	],
	"autoWidth": false,


	"columnDefs": [ {
		"targets": -1,
		"data": null,
		"defaultContent": "<td align='center'><a href='#view_update_data' role='button' id='details' class='btn btn-primary btn-xs small_btn' title='Details' data-toggle='modal'><i class='fa fa-bars'></i> View</a> </td> "
	} ],

	"aLengthMenu": [
		[10, 25, 50, -1],
		[10, 25, 50, "All"]
	],
	// set the initial value
	"iDisplayLength": 10,
	"bFilter" : true,
	"bLengthChange": true,
	"bInfo": true,
	"bPaginate": true,
	"aaSorting": [[ 0, "asc" ]],

} );


$('#unitTable tbody').on( 'click', '#details', function () {
	var data = unitTable.row( $(this).parents('tr') ).data();
	$('#modal_unit_name').val(data[1]);
	$('#modal_status').val(data[2]);
	$('#modal_unit_id').val(data[3]);
} );

$("#addForm").validate({

	rules:
		{
			unit_name:
				{
					required: true,
				},
		},

	messages:
		{
			unit_name:
				{
					required: "Please type unit name",
				},
		},

	submitHandler: function(form) {

		$('.submit_button').css('cursor', 'wait');
		$('.submit_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "newUnitEntryProcess",
			type: 'POST',
			data: $('#addForm').serialize(),
			dataType:'json',
			success: function(res) {
				$('.open').trigger('click');

				var response_brought = res.response.indexOf('Unit save successfully');


				if (response_brought != -1)
				{
					swal({
						title: "Unit Added Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#addForm").trigger("reset");
					unitTable.ajax.reload();
				}



				$('.submit_button').css('cursor', 'pointer');
				$('.submit_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function(error, element)
	{
		error.insertAfter(element.parent());
	}

});

$("#updateForm").validate({

	rules:
		{
			unit_name:
				{
					required: true,
				},
			status:
				{
					required: true,
				},
		},

	messages:
		{
			unit_name:
				{
					required: "Please type unit name",
				},
			status:
				{
					required: "Please select a status",
				},
		},

	submitHandler: function(form) {

		$('.update_button').css('cursor', 'wait');
		$('.update_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "unitEditProcess",
			type: 'POST',
			data: $('#updateForm').serialize(),
			dataType:'json',
			success: function(res) {
				var response_brought = res.response.indexOf('Unit update successfully');
				if (response_brought != -1)
				{
					swal({
						title: "Unit Update Successfully",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#updateForm").trigger("reset");
					$('#view_update_data').modal('hide');
					unitTable.ajax.reload();
				}



				$('.update_button').css('cursor', 'pointer');
				$('.update_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function(error, element)
	{
		error.insertAfter(element.parent());
	}

});
