var baseURL = $('body').data('baseurl');
var token_key = $('#token_key').val();

$("#addForm").validate({

	rules:
	{
		sender_name:
		{
			required: true,
		},
		sender_contact:
		{
			required: true,
			number: true,
		},
		sender_email:
		{
			required: true,
			email: true
		},
		subject:
		{
			required: true,
		},
		message:
		{
			required: true,
		},
	},

	messages:
	{
		sender_name:
		{
			required: 'Please type your name',
		},
		sender_contact:
		{
			required: 'Please type your contact no',
			number: 'Please type a valid contact no',
		},
		sender_email:
		{
			required: 'Please type your email',
			email: 'Please type a valid email'
		},
		subject:
		{
			required: 'Please type your subject',
		},
		message:
		{
			required: 'Please type your message',
		},
	},

	submitHandler: function (form) {

		$('.submit_button').css('cursor', 'wait');
		$('.submit_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "send_message",
			type: 'POST',
			data: $('#addForm').serialize(),
			dataType: 'json',
			success: function (res) {
				var response_brought = res.response.indexOf('Message Send successfully Done');


				if (response_brought != -1) {
					swal({
						title: "Message Send successfully Done",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#addForm").trigger("reset");
				}

				$('.submit_button').css('cursor', 'pointer');
				$('.submit_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function (error, element) {
		error.insertAfter(element.parent());
	}

});


// product_quotation

$("#product_quotation").validate({

	rules:
	{
		product_quantity: {
			required: true,
			number: true,
			maxlength: 3
		},
		user_name:
		{
			required: true,
		},
		user_phone_number: {
			required: true,
			number: true,
			minlength: 11,
			maxlength: 11
		},
		user_email:
		{
			required: true,
			email: true
		},
		user_address:
		{
			required: true,
		},
		quotation_message:
		{
			required: true,
		},
	},

	messages:
	{
		product_quantity: {
			required: 'Please type your quantity'
		},
		user_name:
		{
			required: 'Please type your name'
		},
		user_phone_number: {
			required: 'Please type your phone number'
		},
		user_email:
		{
			required: 'Please type your email'
		},
		user_address:
		{
			required: 'Please type your address'
		},
		quotation_message:
		{
			required: 'Please type your quotation message'
		}
	},

	submitHandler: function (form) {

		$('.submit_button').css('cursor', 'wait');
		$('.submit_button').attr('disabled', true);

		$.ajax({
			url: baseURL + "send_quotation_inquiry",
			type: 'POST',
			data: $('#product_quotation').serialize(),
			dataType: 'json',
			success: function (res) {
				console.log(res);
				var response_brought = res.response.indexOf('Inquiry Sended successfully');


				if (response_brought != -1) {
					swal({
						title: "Inquiry Send successfully!",
						type: "success",
						timer: 1500,
						showConfirmButton: false,
						customClass: 'swal-height'
					});

					$("#product_quotation").trigger("reset");
				}

				$('.submit_button').css('cursor', 'pointer');
				$('.submit_button').removeAttr('disabled');

			}
		});
	},                                                // Do not change code below
	errorPlacement: function (error, element) {
		error.insertAfter(element.parent());
	}

});


$(function () {
	getLastMessage();
});
function getLastMessage() {
	$.ajax({
		url: baseURL + "getLastMessage",
		type: 'GET',
		dataType: 'json',
		cache: false,
		processData: false,
		success: function (response) {
			if (response != "No message") {
				$('#see-msg').show();
				$('#sender_name').text(response['sender_name']);
				$('#sender_contact').text(response['sender_contact']);
				$('#sender_email').text(response['sender_email']);
				$('#subject').text(response['subject']);
				var message = "" + response['message'] + "";
				$('#full_message').html(message);
			}
			else {
				$('#see-msg').hide();
			}
		}
	})
}
